/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.text;

import com.google.common.base.Function;
import java.util.Formattable;
import java.util.Formatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.text.Strings;

public class ByteSizeStrings
implements Function<Long, String> {
    private static final ByteSizeStrings JAVA = ByteSizeStrings.builder().suffixBytes("").suffixKilo("k").suffixMega("m").suffixGiga("g").suffixTera("000g").noSpace().bytesPerMetricUnit(1024).maxLen(6).precision(0).lowerLimit(10).build();
    private static ByteSizeStrings ISO = ByteSizeStrings.builder().suffixBytes("B").suffixKilo("KiB").suffixMega("MiB").suffixGiga("GiB").suffixTera("TiB").bytesPerMetricUnit(1024).build();
    private static ByteSizeStrings METRIC = ByteSizeStrings.builder().build();
    private String suffixBytes;
    private String suffixKilo;
    private String suffixMega;
    private String suffixGiga;
    private String suffixTera;
    private int bytesPerMetricUnit;
    private int maxLen;
    private int precision;
    private int lowerLimit;

    public static Builder builder() {
        return new Builder();
    }

    public static final ByteSizeStrings java() {
        return JAVA;
    }

    public static ByteSizeStrings iso() {
        return ISO;
    }

    public static ByteSizeStrings metric() {
        return METRIC;
    }

    private ByteSizeStrings(String suffixBytes, String suffixKilo, String suffixMega, String suffixGiga, String suffixTera, int bytesPerMetricUnit, int maxLen, int precision, int lowerLimit) {
        this.suffixBytes = suffixBytes;
        this.suffixKilo = suffixKilo;
        this.suffixMega = suffixMega;
        this.suffixGiga = suffixGiga;
        this.suffixTera = suffixTera;
        this.bytesPerMetricUnit = bytesPerMetricUnit;
        this.maxLen = maxLen;
        this.precision = precision;
        this.lowerLimit = lowerLimit;
    }

    @Deprecated
    public ByteSizeStrings() {
    }

    @Deprecated
    public void setSuffixBytes(String suffixBytes) {
        this.suffixBytes = suffixBytes;
    }

    @Deprecated
    public void setSuffixKilo(String suffixKilo) {
        this.suffixKilo = suffixKilo;
    }

    @Deprecated
    public void setSuffixMega(String suffixMega) {
        this.suffixMega = suffixMega;
    }

    @Deprecated
    public void setSuffixGiga(String suffixGiga) {
        this.suffixGiga = suffixGiga;
    }

    @Deprecated
    public void setSuffixTera(String suffixTera) {
        this.suffixTera = suffixTera;
    }

    @Deprecated
    public void setBytesPerMetricUnit(int bytesPerMetricUnit) {
        this.bytesPerMetricUnit = bytesPerMetricUnit;
    }

    @Deprecated
    public void setMaxLen(int maxLen) {
        this.maxLen = maxLen;
    }

    @Deprecated
    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @Deprecated
    public void setLowerLimit(int lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public String makeSizeString(long size) {
        return this.makeSizeString(size, this.precision);
    }

    public String makeSizeString(long size, int precision) {
        long t = size;
        if (t == 0L) {
            return "0" + this.suffixBytes;
        }
        if (t < 0L) {
            return "-" + this.makeSizeString(-t);
        }
        long b = t % (long)this.bytesPerMetricUnit;
        long kb = (t /= (long)this.bytesPerMetricUnit) % (long)this.bytesPerMetricUnit;
        long mb = (t /= (long)this.bytesPerMetricUnit) % (long)this.bytesPerMetricUnit;
        long gb = (t /= (long)this.bytesPerMetricUnit) % (long)this.bytesPerMetricUnit;
        long tb = t /= (long)this.bytesPerMetricUnit;
        if (tb > (long)this.lowerLimit) {
            return Strings.makeRealString((double)tb + 1.0 * (double)gb / (double)this.bytesPerMetricUnit, -1, precision, 0) + this.suffixTera;
        }
        if (gb > (long)this.lowerLimit) {
            return Strings.makeRealString((double)(tb * (long)this.bytesPerMetricUnit + gb) + 1.0 * (double)mb / (double)this.bytesPerMetricUnit, this.maxLen, precision, 0) + this.suffixGiga;
        }
        if (mb > (long)this.lowerLimit) {
            return Strings.makeRealString((double)(gb * (long)this.bytesPerMetricUnit + mb) + 1.0 * (double)kb / (double)this.bytesPerMetricUnit, this.maxLen, precision, 0) + this.suffixMega;
        }
        if (kb > (long)this.lowerLimit) {
            return Strings.makeRealString((double)(mb * (long)this.bytesPerMetricUnit + kb) + 1.0 * (double)b / (double)this.bytesPerMetricUnit, this.maxLen, precision, 0) + this.suffixKilo;
        }
        return kb * (long)this.bytesPerMetricUnit + b + this.suffixBytes;
    }

    public Formattable formatted(final long bytes) {
        return new Formattable(){

            @Override
            public void formatTo(Formatter formatter, int flags, int width, int precision) {
                ByteSizeStrings strings;
                boolean alternate = (flags & 4) == 4;
                ByteSizeStrings byteSizeStrings = strings = alternate ? ByteSizeStrings.metric() : ByteSizeStrings.this;
                if (precision != -1) {
                    formatter.format("%s", strings.makeSizeString(bytes, precision));
                } else {
                    formatter.format("%s", strings.makeSizeString(bytes));
                }
            }
        };
    }

    @Nullable
    public String apply(@Nullable Long input) {
        if (input == null) {
            return null;
        }
        return this.makeSizeString(input);
    }

    public static long parse(String sizeString) {
        return ByteSizeStrings.parse(sizeString, null);
    }

    public static long parse(String sizeString, String defaultUnits) {
        return ByteSizeStrings.parse(sizeString, defaultUnits, null);
    }

    public static long parse(String sizeStringOriginal, String defaultUnit, ByteSizeStrings bytesMode) {
        String units;
        String sizeString = sizeStringOriginal.trim();
        Matcher matcher = Pattern.compile("[A-Za-z]+").matcher(sizeString);
        if (!matcher.find()) {
            if (defaultUnit == null) {
                throw new IllegalArgumentException("Cannot parse '" + sizeStringOriginal + "' as a size string");
            }
            units = defaultUnit;
        } else {
            units = matcher.group();
            int unitsIndex = sizeString.indexOf(units);
            if (sizeString.length() > unitsIndex + units.length()) {
                throw new IllegalArgumentException("Cannot parse '" + sizeStringOriginal + "' as a size string");
            }
            sizeString = sizeString.substring(0, unitsIndex).trim();
        }
        int exponent = -1;
        ByteSizeStrings matchedMode = null;
        ByteSizeStrings[] byteSizeStringsArray = new ByteSizeStrings[]{ISO, JAVA, METRIC};
        int n = byteSizeStringsArray.length;
        for (int i = 0; i < n; ++i) {
            ByteSizeStrings mode;
            matchedMode = mode = byteSizeStringsArray[i];
            if (units.equalsIgnoreCase(mode.suffixBytes.trim())) {
                exponent = 0;
                break;
            }
            if (units.equalsIgnoreCase(mode.suffixKilo.trim())) {
                exponent = 1;
                break;
            }
            if (units.equalsIgnoreCase(mode.suffixMega.trim())) {
                exponent = 2;
                break;
            }
            if (units.equalsIgnoreCase(mode.suffixGiga.trim())) {
                exponent = 3;
                break;
            }
            if (!units.equalsIgnoreCase(mode.suffixTera.trim())) continue;
            exponent = 4;
            break;
        }
        if (exponent == -1) {
            if (units.equalsIgnoreCase("t")) {
                exponent = 4;
                matchedMode = ByteSizeStrings.java();
            } else {
                throw new IllegalArgumentException("Cannot parse '" + sizeStringOriginal + "' as a size string (as '" + sizeString + "' " + units + ")");
            }
        }
        double base = Double.parseDouble(sizeString.trim());
        if (bytesMode == null) {
            bytesMode = matchedMode;
        }
        while (exponent > 0) {
            base *= (double)bytesMode.bytesPerMetricUnit;
            --exponent;
        }
        return (long)base;
    }

    public static class Builder {
        private String suffixBytes = "B";
        private String suffixKilo = "kB";
        private String suffixMega = "MB";
        private String suffixGiga = "GB";
        private String suffixTera = "TB";
        private boolean addSpace = true;
        private int bytesPerMetricUnit = 1000;
        private int maxLen = 4;
        private int precision = 3;
        private int lowerLimit = 1;

        public Builder suffixBytes(String suffixBytes) {
            this.suffixBytes = suffixBytes;
            return this;
        }

        public Builder suffixKilo(String suffixKilo) {
            this.suffixKilo = suffixKilo;
            return this;
        }

        public Builder suffixMega(String suffixMega) {
            this.suffixMega = suffixMega;
            return this;
        }

        public Builder suffixGiga(String suffixGiga) {
            this.suffixGiga = suffixGiga;
            return this;
        }

        public Builder suffixTera(String suffixTera) {
            this.suffixTera = suffixTera;
            return this;
        }

        public Builder addSpace(boolean addSpace) {
            this.addSpace = addSpace;
            return this;
        }

        public Builder addSpace() {
            this.addSpace = true;
            return this;
        }

        public Builder noSpace() {
            this.addSpace = false;
            return this;
        }

        public Builder bytesPerMetricUnit(int bytesPerMetricUnit) {
            this.bytesPerMetricUnit = bytesPerMetricUnit;
            return this;
        }

        public Builder maxLen(int maxLen) {
            this.maxLen = maxLen;
            return this;
        }

        public Builder precision(int precision) {
            this.precision = precision;
            return this;
        }

        public Builder lowerLimit(int lowerLimit) {
            this.lowerLimit = lowerLimit;
            return this;
        }

        public ByteSizeStrings build() {
            String space = this.addSpace ? " " : "";
            return new ByteSizeStrings(space + this.suffixBytes, space + this.suffixKilo, space + this.suffixMega, space + this.suffixGiga, space + this.suffixTera, this.bytesPerMetricUnit, this.maxLen, this.precision, this.lowerLimit);
        }
    }
}

