/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.camel.v1.integrationspec.Sources;

public class SourcesFluent<A extends SourcesFluent<A>>
extends BaseFluent<A> {
    private Boolean compression;
    private String content;
    private String contentKey;
    private String contentRef;
    private String contentType;
    private Boolean fromKamelet;
    private List<String> interceptors;
    private String language;
    private String loader;
    private String name;
    private String path;
    private List<String> propertyNames;
    private String rawContent;
    private String type;

    public SourcesFluent() {
    }

    public SourcesFluent(Sources instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Sources instance) {
        Sources sources = instance = instance != null ? instance : new Sources();
        if (instance != null) {
            this.withCompression(instance.getCompression());
            this.withContent(instance.getContent());
            this.withContentKey(instance.getContentKey());
            this.withContentRef(instance.getContentRef());
            this.withContentType(instance.getContentType());
            this.withFromKamelet(instance.getFromKamelet());
            this.withInterceptors(instance.getInterceptors());
            this.withLanguage(instance.getLanguage());
            this.withLoader(instance.getLoader());
            this.withName(instance.getName());
            this.withPath(instance.getPath());
            this.withPropertyNames(instance.getPropertyNames());
            this.withRawContent(instance.getRawContent());
            this.withType(instance.getType());
        }
    }

    public Boolean getCompression() {
        return this.compression;
    }

    public A withCompression(Boolean compression) {
        this.compression = compression;
        return (A)((Object)this);
    }

    public boolean hasCompression() {
        return this.compression != null;
    }

    public String getContent() {
        return this.content;
    }

    public A withContent(String content) {
        this.content = content;
        return (A)((Object)this);
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public String getContentKey() {
        return this.contentKey;
    }

    public A withContentKey(String contentKey) {
        this.contentKey = contentKey;
        return (A)((Object)this);
    }

    public boolean hasContentKey() {
        return this.contentKey != null;
    }

    public String getContentRef() {
        return this.contentRef;
    }

    public A withContentRef(String contentRef) {
        this.contentRef = contentRef;
        return (A)((Object)this);
    }

    public boolean hasContentRef() {
        return this.contentRef != null;
    }

    public String getContentType() {
        return this.contentType;
    }

    public A withContentType(String contentType) {
        this.contentType = contentType;
        return (A)((Object)this);
    }

    public boolean hasContentType() {
        return this.contentType != null;
    }

    public Boolean getFromKamelet() {
        return this.fromKamelet;
    }

    public A withFromKamelet(Boolean fromKamelet) {
        this.fromKamelet = fromKamelet;
        return (A)((Object)this);
    }

    public boolean hasFromKamelet() {
        return this.fromKamelet != null;
    }

    public A addToInterceptors(int index, String item) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<String>();
        }
        this.interceptors.add(index, item);
        return (A)((Object)this);
    }

    public A setToInterceptors(int index, String item) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<String>();
        }
        this.interceptors.set(index, item);
        return (A)((Object)this);
    }

    public A addToInterceptors(String ... items) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<String>();
        }
        for (String item : items) {
            this.interceptors.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToInterceptors(Collection<String> items) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<String>();
        }
        for (String item : items) {
            this.interceptors.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromInterceptors(String ... items) {
        if (this.interceptors == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.interceptors.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromInterceptors(Collection<String> items) {
        if (this.interceptors == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.interceptors.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getInterceptors() {
        return this.interceptors;
    }

    public String getInterceptor(int index) {
        return this.interceptors.get(index);
    }

    public String getFirstInterceptor() {
        return this.interceptors.get(0);
    }

    public String getLastInterceptor() {
        return this.interceptors.get(this.interceptors.size() - 1);
    }

    public String getMatchingInterceptor(Predicate<String> predicate) {
        for (String item : this.interceptors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingInterceptor(Predicate<String> predicate) {
        for (String item : this.interceptors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInterceptors(List<String> interceptors) {
        if (interceptors != null) {
            this.interceptors = new ArrayList<String>();
            for (String item : interceptors) {
                this.addToInterceptors(item);
            }
        } else {
            this.interceptors = null;
        }
        return (A)((Object)this);
    }

    public A withInterceptors(String ... interceptors) {
        if (this.interceptors != null) {
            this.interceptors.clear();
            this._visitables.remove((Object)"interceptors");
        }
        if (interceptors != null) {
            for (String item : interceptors) {
                this.addToInterceptors(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasInterceptors() {
        return this.interceptors != null && !this.interceptors.isEmpty();
    }

    public String getLanguage() {
        return this.language;
    }

    public A withLanguage(String language) {
        this.language = language;
        return (A)((Object)this);
    }

    public boolean hasLanguage() {
        return this.language != null;
    }

    public String getLoader() {
        return this.loader;
    }

    public A withLoader(String loader) {
        this.loader = loader;
        return (A)((Object)this);
    }

    public boolean hasLoader() {
        return this.loader != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public A addToPropertyNames(int index, String item) {
        if (this.propertyNames == null) {
            this.propertyNames = new ArrayList<String>();
        }
        this.propertyNames.add(index, item);
        return (A)((Object)this);
    }

    public A setToPropertyNames(int index, String item) {
        if (this.propertyNames == null) {
            this.propertyNames = new ArrayList<String>();
        }
        this.propertyNames.set(index, item);
        return (A)((Object)this);
    }

    public A addToPropertyNames(String ... items) {
        if (this.propertyNames == null) {
            this.propertyNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.propertyNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPropertyNames(Collection<String> items) {
        if (this.propertyNames == null) {
            this.propertyNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.propertyNames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPropertyNames(String ... items) {
        if (this.propertyNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.propertyNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPropertyNames(Collection<String> items) {
        if (this.propertyNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.propertyNames.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPropertyNames() {
        return this.propertyNames;
    }

    public String getPropertyName(int index) {
        return this.propertyNames.get(index);
    }

    public String getFirstPropertyName() {
        return this.propertyNames.get(0);
    }

    public String getLastPropertyName() {
        return this.propertyNames.get(this.propertyNames.size() - 1);
    }

    public String getMatchingPropertyName(Predicate<String> predicate) {
        for (String item : this.propertyNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPropertyName(Predicate<String> predicate) {
        for (String item : this.propertyNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPropertyNames(List<String> propertyNames) {
        if (propertyNames != null) {
            this.propertyNames = new ArrayList<String>();
            for (String item : propertyNames) {
                this.addToPropertyNames(item);
            }
        } else {
            this.propertyNames = null;
        }
        return (A)((Object)this);
    }

    public A withPropertyNames(String ... propertyNames) {
        if (this.propertyNames != null) {
            this.propertyNames.clear();
            this._visitables.remove((Object)"propertyNames");
        }
        if (propertyNames != null) {
            for (String item : propertyNames) {
                this.addToPropertyNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPropertyNames() {
        return this.propertyNames != null && !this.propertyNames.isEmpty();
    }

    public String getRawContent() {
        return this.rawContent;
    }

    public A withRawContent(String rawContent) {
        this.rawContent = rawContent;
        return (A)((Object)this);
    }

    public boolean hasRawContent() {
        return this.rawContent != null;
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourcesFluent that = (SourcesFluent)((Object)o);
        if (!Objects.equals(this.compression, that.compression)) {
            return false;
        }
        if (!Objects.equals(this.content, that.content)) {
            return false;
        }
        if (!Objects.equals(this.contentKey, that.contentKey)) {
            return false;
        }
        if (!Objects.equals(this.contentRef, that.contentRef)) {
            return false;
        }
        if (!Objects.equals(this.contentType, that.contentType)) {
            return false;
        }
        if (!Objects.equals(this.fromKamelet, that.fromKamelet)) {
            return false;
        }
        if (!Objects.equals(this.interceptors, that.interceptors)) {
            return false;
        }
        if (!Objects.equals(this.language, that.language)) {
            return false;
        }
        if (!Objects.equals(this.loader, that.loader)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.propertyNames, that.propertyNames)) {
            return false;
        }
        if (!Objects.equals(this.rawContent, that.rawContent)) {
            return false;
        }
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.compression, this.content, this.contentKey, this.contentRef, this.contentType, this.fromKamelet, this.interceptors, this.language, this.loader, this.name, this.path, this.propertyNames, this.rawContent, this.type, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.compression != null) {
            sb.append("compression:");
            sb.append(this.compression + ",");
        }
        if (this.content != null) {
            sb.append("content:");
            sb.append(this.content + ",");
        }
        if (this.contentKey != null) {
            sb.append("contentKey:");
            sb.append(this.contentKey + ",");
        }
        if (this.contentRef != null) {
            sb.append("contentRef:");
            sb.append(this.contentRef + ",");
        }
        if (this.contentType != null) {
            sb.append("contentType:");
            sb.append(this.contentType + ",");
        }
        if (this.fromKamelet != null) {
            sb.append("fromKamelet:");
            sb.append(this.fromKamelet + ",");
        }
        if (this.interceptors != null && !this.interceptors.isEmpty()) {
            sb.append("interceptors:");
            sb.append(this.interceptors + ",");
        }
        if (this.language != null) {
            sb.append("language:");
            sb.append(this.language + ",");
        }
        if (this.loader != null) {
            sb.append("loader:");
            sb.append(this.loader + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.propertyNames != null && !this.propertyNames.isEmpty()) {
            sb.append("propertyNames:");
            sb.append(this.propertyNames + ",");
        }
        if (this.rawContent != null) {
            sb.append("rawContent:");
            sb.append(this.rawContent + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withCompression() {
        return this.withCompression(true);
    }

    public A withFromKamelet() {
        return this.withFromKamelet(true);
    }
}

