/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.azurecosmosdbsink;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelAzurecosmosdbsinkSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_DATABASE_NAME_CONF = "camel.kamelet.azure-cosmosdb-sink.databaseName";
    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_DATABASE_NAME_DOC = "The Azure Cosmos database name.";
    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_DATABASE_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_CONTAINER_NAME_CONF = "camel.kamelet.azure-cosmosdb-sink.containerName";
    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_CONTAINER_NAME_DOC = "The Azure Cosmos container name.";
    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_CONTAINER_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_ACCOUNT_KEY_CONF = "camel.kamelet.azure-cosmosdb-sink.accountKey";
    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_ACCOUNT_KEY_DOC = "The Azure Cosmos account Key.";
    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_ACCOUNT_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_DATABASE_ENDPOINT_CONF = "camel.kamelet.azure-cosmosdb-sink.databaseEndpoint";
    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_DATABASE_ENDPOINT_DOC = "Sets the Azure Cosmos database endpoint the component will connect to.";
    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_DATABASE_ENDPOINT_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_ITEM_PARTITION_KEY_CONF = "camel.kamelet.azure-cosmosdb-sink.itemPartitionKey";
    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_ITEM_PARTITION_KEY_DOC = "Represents a partition key value in the Azure Cosmos DB database service. A partition key identifies the partition where the item is stored in.";
    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_ITEM_PARTITION_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_CREDENTIAL_TYPE_CONF = "camel.kamelet.azure-cosmosdb-sink.credentialType";
    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_CREDENTIAL_TYPE_DOC = "Determines the credential strategy to adopt.";
    public static final String CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_CREDENTIAL_TYPE_DEFAULT = "SHARED_ACCOUNT_KEY";

    public CamelAzurecosmosdbsinkSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelAzurecosmosdbsinkSinkConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_DATABASE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_DATABASE_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_DATABASE_NAME_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_CONTAINER_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_CONTAINER_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_CONTAINER_NAME_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_ACCOUNT_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_ACCOUNT_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_ACCOUNT_KEY_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_DATABASE_ENDPOINT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_DATABASE_ENDPOINT_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_DATABASE_ENDPOINT_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_ITEM_PARTITION_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_ITEM_PARTITION_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_ITEM_PARTITION_KEY_DOC);
        conf.define(CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_CREDENTIAL_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_CREDENTIAL_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AZURECOSMOSDBSINK_KAMELET_CREDENTIAL_TYPE_DOC);
        return conf;
    }
}