/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.io.File;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.modeler.CayenneModelerController;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.ClassLoadingService;
import org.apache.cayenne.modeler.CodeTemplateManager;
import org.apache.cayenne.modeler.FileClassLoadingService;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.dialog.LogConsole;
import org.apache.cayenne.modeler.dialog.pref.ClasspathPreferences;
import org.apache.cayenne.modeler.undo.CayenneUndoManager;
import org.apache.cayenne.modeler.util.AdapterMapping;
import org.apache.cayenne.modeler.util.WidgetFactory;
import org.apache.cayenne.pref.CayennePreference;
import org.apache.cayenne.pref.CayenneProjectPreferences;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.swing.BindingFactory;
import org.apache.cayenne.util.IDUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application {
    public static final String DEFAULT_MESSAGE_BUNDLE = "org.apache.cayenne.modeler.cayennemodeler-strings";
    public static final String APPLICATION_NAME_PROPERTY = "cayenne.modeler.application.name";
    public static final String DEFAULT_APPLICATION_NAME = "CayenneModeler";
    private static Application instance;
    protected FileClassLoadingService modelerClassLoader;
    protected CayenneModelerController frameController;
    protected String name;
    protected BindingFactory bindingFactory;
    protected AdapterMapping adapterMapping;
    protected CayenneUndoManager undoManager;
    protected CayenneProjectPreferences cayenneProjectPreferences;
    protected CayennePreference cayennePreference;
    @Inject
    protected Injector injector;
    private String newProjectTemporaryName;

    public static Application getInstance() {
        return instance;
    }

    public static void setInstance(Application instance) {
        Application.instance = instance;
    }

    public static WidgetFactory getWidgetFactory() {
        return instance.getInjector().getInstance(WidgetFactory.class);
    }

    public static CayenneModelerFrame getFrame() {
        return (CayenneModelerFrame)Application.getInstance().getFrameController().getView();
    }

    public String getNewProjectTemporaryName() {
        if (this.newProjectTemporaryName == null) {
            StringBuffer buffer = new StringBuffer("new_project_");
            for (byte aKey : IDUtil.pseudoUniqueByteSequence(16)) {
                IDUtil.appendFormattedByte(buffer, aKey);
            }
            this.newProjectTemporaryName = buffer.toString();
        }
        return this.newProjectTemporaryName;
    }

    public Application() {
        String configuredName = System.getProperty(APPLICATION_NAME_PROPERTY);
        this.name = configuredName != null ? configuredName : DEFAULT_APPLICATION_NAME;
        this.cayennePreference = new CayennePreference();
    }

    public Injector getInjector() {
        return this.injector;
    }

    public Project getProject() {
        return this.getFrameController().getProjectController().getProject();
    }

    public Preferences getPreferencesNode(Class<?> className, String path) {
        return this.cayennePreference.getNode(className, path);
    }

    public String getName() {
        return this.name;
    }

    public ClassLoadingService getClassLoadingService() {
        return this.modelerClassLoader;
    }

    public AdapterMapping getAdapterMapping() {
        return this.adapterMapping;
    }

    public ActionManager getActionManager() {
        return this.injector.getInstance(ActionManager.class);
    }

    public CayenneUndoManager getUndoManager() {
        return this.undoManager;
    }

    public CayenneModelerController getFrameController() {
        return this.frameController;
    }

    public void startup() {
        this.initPreferences();
        this.initClassLoader();
        this.bindingFactory = new BindingFactory();
        this.adapterMapping = new AdapterMapping();
        this.undoManager = new CayenneUndoManager(this);
        this.frameController = new CayenneModelerController(this);
        this.frameController.startupAction();
        LogConsole.getInstance().showConsoleIfNeeded();
        Application.getFrame().setVisible(true);
    }

    public BindingFactory getBindingFactory() {
        return this.bindingFactory;
    }

    public CayenneProjectPreferences getCayenneProjectPreferences() {
        return this.cayenneProjectPreferences;
    }

    public Preferences getMainPreferenceForProject() {
        DataChannelDescriptor descriptor = (DataChannelDescriptor)this.getFrameController().getProjectController().getProject().getRootNode();
        if (descriptor.getConfigurationSource() == null) {
            return this.getPreferencesNode(this.getProject().getClass(), this.getNewProjectTemporaryName());
        }
        String path = CayennePreference.filePathToPrefereceNodePath(descriptor.getConfigurationSource().getURL().getPath());
        Preferences pref = this.getPreferencesNode(this.getProject().getClass(), "");
        return pref.node(pref.absolutePath() + path);
    }

    public CodeTemplateManager getCodeTemplateManager() {
        return new CodeTemplateManager(this);
    }

    public void initClassLoader() {
        final FileClassLoadingService classLoader = new FileClassLoadingService();
        Preferences classLoaderPreference = Application.getInstance().getPreferencesNode(ClasspathPreferences.class, "");
        ArrayList details = new ArrayList();
        String[] keys = null;
        ArrayList<String> values = new ArrayList<String>();
        try {
            for (String cpKey : keys = classLoaderPreference.keys()) {
                values.add(classLoaderPreference.get(cpKey, ""));
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        for (int i = 0; i < values.size(); ++i) {
            details.add(values.get(i));
        }
        if (details.size() > 0) {
            Transformer transformer = new Transformer(){

                public Object transform(Object object) {
                    String pref = (String)object;
                    return new File(pref);
                }
            };
            classLoader.setPathFiles(CollectionUtils.collect(details, transformer));
        }
        this.modelerClassLoader = classLoader;
        if (SwingUtilities.isEventDispatchThread()) {
            Thread.currentThread().setContextClassLoader(classLoader.getClassLoader());
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Thread.currentThread().setContextClassLoader(classLoader.getClassLoader());
                }
            });
        }
    }

    protected void initPreferences() {
        this.cayenneProjectPreferences = new CayenneProjectPreferences();
    }
}

