/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Component;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ModelerPreferences;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.event.RecentFileListListener;
import org.apache.cayenne.swing.control.FileMenuItem;

public class RecentFileMenu
extends JMenu
implements RecentFileListListener {
    public RecentFileMenu(String s) {
        super(s);
    }

    public FileMenuItem add(FileMenuItem menuItem) {
        return (FileMenuItem)super.add(menuItem);
    }

    public void rebuildFromPreferences() {
        int i;
        List<String> arr = ModelerPreferences.getLastProjFiles();
        while (arr.size() > 12) {
            arr.remove(arr.size() - 1);
        }
        Component[] comps = this.getMenuComponents();
        int curSize = comps.length;
        int prefSize = arr.size();
        for (i = 0; i < prefSize; ++i) {
            FileMenuItem item;
            String name = arr.get(i);
            if (i < curSize) {
                item = (FileMenuItem)comps[i];
                item.setText(name);
                continue;
            }
            item = new FileMenuItem(name);
            item.setAction(this.findAction());
            this.add(item);
        }
        for (i = curSize - 1; i >= prefSize; --i) {
            this.remove(i);
        }
    }

    protected Action findAction() {
        return Application.getInstance().getActionManager().getAction(OpenProjectAction.class);
    }

    public void recentFileListChanged() {
        this.rebuildFromPreferences();
        this.setEnabled(this.getMenuComponentCount() > 0);
    }
}

