/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.SimpleNode;

public class ASTList
extends SimpleNode {
    protected Object[] values;

    ASTList(int id) {
        super(id);
    }

    public ASTList() {
        super(20);
    }

    public ASTList(Object[] objects) {
        super(20);
        this.setValues(objects);
    }

    public ASTList(Collection objects) {
        super(20);
        this.setValues(objects);
    }

    public ASTList(Iterator objects) {
        super(20);
        this.setValues(objects);
    }

    public Expression shallowCopy() {
        return new ASTList(this.id);
    }

    protected Object evaluateNode(Object o) throws Exception {
        return this.values;
    }

    public int getType() {
        return 28;
    }

    protected String getExpressionOperator(int index) {
        return ",";
    }

    public void encodeAsString(PrintWriter pw) {
        pw.print('(');
        if (this.values != null && this.values.length > 0) {
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    pw.print(this.getExpressionOperator(i));
                    pw.print(' ');
                }
                if (this.values[i] instanceof Expression) {
                    ((Expression)this.values[i]).encodeAsString(pw);
                    continue;
                }
                ASTList.encodeScalarAsString(pw, this.values[i], '\"');
            }
        }
        pw.print(')');
    }

    public void encodeAsEJBQL(PrintWriter pw, String rootId) {
        if (this.parent != null) {
            pw.print("(");
        }
        if (this.values != null && this.values.length > 0) {
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    pw.print(this.getEJBQLExpressionOperator(i));
                    pw.print(' ');
                }
                if (this.values[i] == null) {
                    pw.print("null");
                    continue;
                }
                SimpleNode.encodeScalarAsString(pw, this.values[i], '\'');
            }
        }
        if (this.parent != null) {
            pw.print(')');
        }
    }

    public int getOperandCount() {
        return 1;
    }

    public Object getOperand(int index) {
        if (index == 0) {
            return this.values;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public void setOperand(int index, Object value) {
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.setValues(value);
    }

    protected void setValues(Object value) {
        if (value == null) {
            this.values = null;
        } else if (value instanceof Object[]) {
            this.values = (Object[])value;
        } else if (value instanceof Collection) {
            this.values = ((Collection)value).toArray();
        } else if (value instanceof Iterator) {
            ArrayList values = new ArrayList();
            Iterator it = (Iterator)value;
            while (it.hasNext()) {
                values.add(it.next());
            }
            this.values = values.toArray();
        } else {
            throw new IllegalArgumentException("Invalid value class '" + value.getClass().getName() + "', expected null, Object[], Collection, Iterator");
        }
    }

    public void jjtClose() {
        super.jjtClose();
        int size = this.jjtGetNumChildren();
        Object[] listValue = new Object[size];
        for (int i = 0; i < size; ++i) {
            listValue[i] = this.unwrapChild(this.jjtGetChild(i));
        }
        this.setValues(listValue);
        this.children = null;
    }
}

