/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing.components.textpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JTextPane;
import javax.swing.border.AbstractBorder;
import javax.swing.text.Document;
import org.apache.cayenne.swing.components.textpane.JCayenneTextPane;

public class LineNumberedBorder
extends AbstractBorder {
    private int etalon;
    private int lineNumberWidth;
    private JCayenneTextPane pane;

    public LineNumberedBorder(JCayenneTextPane pane) {
        this.setEtalon(10);
        this.pane = pane;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        if (c instanceof JTextPane) {
            int width;
            insets.left = width = this.lineNumberWidth((JTextPane)c);
        }
        return insets;
    }

    private int lineNumberWidth(JTextPane textPane) {
        int lineCount = this.getEtalon();
        this.setLineNumberWidth(textPane.getFontMetrics(textPane.getFont()).stringWidth(lineCount + " "));
        return this.getLineNumberWidth();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int yend;
        Rectangle clip = g.getClipBounds();
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        int ybaseline = y + fm.getAscent();
        int startingLineNumber = clip.y / fontHeight + 1;
        if (ybaseline < clip.y) {
            ybaseline = y + startingLineNumber * fontHeight - (fontHeight - fm.getAscent());
        }
        if ((yend = ybaseline + height) > y + height) {
            yend = y + height;
        }
        int lnxstart = x;
        int widhtBorder = this.getLineNumberWidth() - 2;
        g.setColor(new Color(255, 255, 224));
        g.fillRect(lnxstart, 0, lnxstart + widhtBorder, yend);
        g.setColor(new Color(214, 214, 214));
        g.drawRect(lnxstart - 1, -1, lnxstart + widhtBorder, yend + 1);
        int end2 = this.pane.getEndPositionInDocument();
        Document doc = this.pane.getDocument();
        int endline = doc.getDefaultRootElement().getElementIndex(end2) + 1;
        while (startingLineNumber <= endline) {
            g.setColor(Color.gray);
            g.drawString(startingLineNumber + " ", lnxstart + 1, ybaseline);
            ybaseline += fontHeight;
            ++startingLineNumber;
        }
        this.setEtalon(startingLineNumber - 1);
    }

    public int getEtalon() {
        return this.etalon;
    }

    public void setEtalon(int etalon) {
        if (etalon < 10) {
            etalon = 10;
        }
        this.etalon = etalon;
    }

    public int getLineNumberWidth() {
        return this.lineNumberWidth;
    }

    public void setLineNumberWidth(int lineNumberWidth) {
        this.lineNumberWidth = lineNumberWidth;
    }
}

