/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.ejbql;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.translator.ejbql.EJBQLTableId;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslationContext;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.EJBQLParserFactory;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.util.CayenneMapEntry;

public class EJBQLJoinAppender {
    protected EJBQLTranslationContext context;
    private Map<String, String> reusableJoins;

    static String makeJoinTailMarker(String id) {
        return "FROM_TAIL" + id;
    }

    public EJBQLJoinAppender(EJBQLTranslationContext context) {
        this.context = context;
    }

    public String registerReusableJoin(String sourceIdPath, String relationship, String targetId) {
        String key;
        String oldId;
        if (this.reusableJoins == null) {
            this.reusableJoins = new HashMap<String, String>();
        }
        if ((oldId = this.reusableJoins.put(key = sourceIdPath + ":" + relationship, targetId)) != null) {
            this.reusableJoins.put(key, oldId);
            return oldId;
        }
        return null;
    }

    public void appendInnerJoin(String marker, EJBQLTableId lhsId, EJBQLTableId rhsId) {
        this.appendJoin(marker, lhsId, rhsId, "INNER JOIN");
    }

    public void appendOuterJoin(String marker, EJBQLTableId lhsId, EJBQLTableId rhsId) {
        this.appendJoin(marker, lhsId, rhsId, "LEFT OUTER JOIN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendJoin(String marker, EJBQLTableId lhsId, EJBQLTableId rhsId, String semantics) {
        List<DbRelationship> joinRelationships = this.context.getIncomingRelationships(rhsId);
        if (joinRelationships.isEmpty()) {
            throw new EJBQLException("No join configured for id " + rhsId, new Object[0]);
        }
        QuotingStrategy quoter = this.context.getQuotingStrategy();
        DbRelationship incomingDB = joinRelationships.get(0);
        DbEntity sourceEntity = (DbEntity)incomingDB.getSourceEntity();
        String tableName = quoter.quotedFullyQualifiedName(sourceEntity);
        String sourceAlias = this.context.getTableAlias(lhsId.getEntityId(), tableName);
        if (marker != null) {
            this.context.pushMarker(marker, false);
        }
        try {
            this.context.append(" ").append(semantics);
            if (joinRelationships.size() > 1) {
                this.context.append(" ");
                for (int i = 1; i < joinRelationships.size(); ++i) {
                    DbRelationship dbRelationship = joinRelationships.get(i);
                    String subquerySourceTableName = quoter.quotedFullyQualifiedName((DbEntity)dbRelationship.getSourceEntity());
                    String subquerySourceAlias = this.context.getTableAlias(subquerySourceTableName, subquerySourceTableName);
                    String subqueryTargetTableName = quoter.quotedFullyQualifiedName(dbRelationship.getTargetEntity());
                    String subqueryTargetAlias = i == joinRelationships.size() - 1 ? this.context.getTableAlias(rhsId.getEntityId(), subqueryTargetTableName) : this.context.getTableAlias(subqueryTargetTableName, subqueryTargetTableName);
                    if (i == 1) {
                        this.context.append(subquerySourceTableName).append(' ').append(subquerySourceAlias);
                        this.generateJoiningExpression(incomingDB, sourceAlias, subquerySourceAlias);
                    }
                    this.context.append(" JOIN ");
                    this.context.append(subqueryTargetTableName).append(' ').append(subqueryTargetAlias);
                    this.generateJoiningExpression(dbRelationship, subquerySourceAlias, subqueryTargetAlias);
                }
            } else {
                String targetAlias = this.appendTable(rhsId);
                this.generateJoiningExpression(incomingDB, sourceAlias, targetAlias);
            }
        }
        finally {
            if (marker != null) {
                this.context.popMarker();
            }
        }
    }

    private void generateJoiningExpression(DbRelationship incomingDB, String sourceAlias, String targetAlias) {
        DbJoin dbJoin;
        this.context.append(" ON (");
        QuotingStrategy quoter = this.context.getQuotingStrategy();
        Iterator<DbJoin> it = incomingDB.getJoins().iterator();
        if (it.hasNext()) {
            dbJoin = it.next();
            this.context.append(sourceAlias).append('.').append(quoter.quotedSourceName(dbJoin)).append(" = ").append(targetAlias).append('.').append(quoter.quotedTargetName(dbJoin));
        }
        while (it.hasNext()) {
            this.context.append(" AND ");
            dbJoin = it.next();
            this.context.append(sourceAlias).append('.').append(quoter.quotedSourceName(dbJoin)).append(" = ").append(targetAlias).append('.').append(quoter.quotedTargetName(dbJoin));
        }
        this.context.append(")");
    }

    public String appendTable(EJBQLTableId id) {
        Expression qualifier;
        String alias;
        DbEntity dbEntity = id.getDbEntity(this.context);
        String tableName = this.context.getQuotingStrategy().quotedFullyQualifiedName(dbEntity);
        if (this.context.isUsingAliases()) {
            alias = this.context.getTableAlias(id.getEntityId(), tableName);
            this.context.append(' ').append(tableName).append(' ').append(alias);
            this.generateJoinsForFlattenedAttributes(id);
        } else {
            this.context.append(' ').append(tableName);
            alias = tableName;
        }
        if (id.isPrimaryTable() && (qualifier = this.context.getEntityDescriptor(id.getEntityId()).getEntityQualifier()) != null) {
            EJBQLExpression ejbqlQualifier = this.ejbqlQualifierForEntityAndSubclasses(qualifier, id.getEntityId());
            this.context.pushMarker(this.context.makeWhereMarker(), true);
            this.context.append(" WHERE");
            this.context.popMarker();
            this.context.pushMarker(this.context.makeEntityQualifierMarker(), false);
            ejbqlQualifier.visit(this.context.getTranslatorFactory().getConditionTranslator(this.context));
            this.context.popMarker();
        }
        return alias;
    }

    private void generateJoinsForFlattenedAttributes(EJBQLTableId id) {
        String entityName = this.context.getEntityDescriptor(id.getEntityId()).getEntity().getName();
        boolean isProcessingOmitted = id.getDbPath() != null;
        String sourceExpression = this.context.getCompiledExpression().getSource();
        List<Object> resultSetMapping = this.context.getMetadata().getResultSetMapping();
        for (Object mapping : resultSetMapping) {
            if (!(mapping instanceof EntityResultSegment) || !entityName.equals(((EntityResultSegment)mapping).getClassDescriptor().getEntity().getName())) continue;
            isProcessingOmitted = true;
            break;
        }
        if (!isProcessingOmitted) {
            QuotingStrategy quoter = this.context.getQuotingStrategy();
            Collection<ObjAttribute> attributes = this.context.getEntityDescriptor(id.getEntityId()).getEntity().getAttributes();
            for (ObjAttribute objAttribute : attributes) {
                if (!objAttribute.isFlattened() || !sourceExpression.contains(id.getEntityId() + "." + objAttribute.getName())) continue;
                Iterator<CayenneMapEntry> dbPathIterator = objAttribute.getDbPathIterator();
                while (dbPathIterator.hasNext()) {
                    CayenneMapEntry next = dbPathIterator.next();
                    if (!(next instanceof DbRelationship)) continue;
                    DbRelationship rel = (DbRelationship)next;
                    this.context.append(" LEFT OUTER JOIN ");
                    String targetEntityName = quoter.quotedFullyQualifiedName(rel.getTargetEntity());
                    String subqueryTargetAlias = this.context.getTableAlias(id.getEntityId(), targetEntityName);
                    this.context.append(targetEntityName).append(' ').append(subqueryTargetAlias);
                    this.generateJoiningExpression(rel, this.context.getTableAlias(id.getEntityId(), quoter.quotedFullyQualifiedName((DbEntity)rel.getSourceEntity())), subqueryTargetAlias);
                }
            }
        }
    }

    private EJBQLExpression ejbqlQualifierForEntityAndSubclasses(Expression qualifier, String entityId) {
        String ejbqlChunk = qualifier.toEJBQL(entityId);
        EJBQLExpression expression = EJBQLParserFactory.getParser().parse("DELETE FROM DUMMY WHERE " + ejbqlChunk);
        final EJBQLExpression[] result = new EJBQLExpression[1];
        expression.visit(new EJBQLBaseVisitor(){

            @Override
            public boolean visitWhere(EJBQLExpression expression) {
                result[0] = expression.getChild(0);
                return false;
            }
        });
        return result[0];
    }
}

