/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.translator.select.ResultNodeDescriptor;
import org.apache.cayenne.access.translator.select.TranslationStage;
import org.apache.cayenne.access.translator.select.TranslatorContext;

class DistinctStage
implements TranslationStage {
    private static final int[] UNSUPPORTED_DISTINCT_TYPES = new int[]{2004, 2005, 2011, -1, -16, -4};

    DistinctStage() {
    }

    static boolean isUnsupportedForDistinct(int type) {
        for (int unsupportedDistinctType : UNSUPPORTED_DISTINCT_TYPES) {
            if (unsupportedDistinctType != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public void perform(TranslatorContext context) {
        if (context.getMetadata().isSuppressingDistinct()) {
            context.setDistinctSuppression(true);
            return;
        }
        if (!context.getQuery().isDistinct() && !context.getTableTree().hasToManyJoin()) {
            return;
        }
        for (ResultNodeDescriptor node : context.getResultNodeList()) {
            if (!DistinctStage.isUnsupportedForDistinct(node.getJdbcType())) continue;
            context.setDistinctSuppression(true);
            return;
        }
        context.getSelectBuilder().distinct();
    }
}

