/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.spi.DIUtil;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.InjectionStack;

class ConstructorInjectingProvider<T>
implements Provider<T> {
    private Constructor<? extends T> constructor;
    private DefaultInjector injector;
    private String[] bindingNames;

    ConstructorInjectingProvider(Class<? extends T> implementation, DefaultInjector injector) {
        this.initConstructor(implementation);
        if (this.constructor == null) {
            throw new DIRuntimeException("Can't find approprate constructor for implementation class '%s'", implementation.getName());
        }
        this.constructor.setAccessible(true);
        this.injector = injector;
    }

    private void initConstructor(Class<? extends T> implementation) {
        Constructor<?>[] constructors = implementation.getDeclaredConstructors();
        Constructor<?> lastMatch = null;
        int lastSize = -1;
        for (Constructor<?> constructor : constructors) {
            int size = constructor.getParameterTypes().length;
            if (size <= lastSize) continue;
            if (size == 0) {
                lastSize = 0;
                lastMatch = constructor;
                continue;
            }
            boolean injectable = true;
            for (Annotation[] annotations : constructor.getParameterAnnotations()) {
                boolean parameterInjectable = false;
                for (Annotation annotation : annotations) {
                    if (!annotation.annotationType().equals(Inject.class)) continue;
                    parameterInjectable = true;
                    break;
                }
                if (parameterInjectable) continue;
                injectable = false;
                break;
            }
            if (!injectable) continue;
            lastSize = size;
            lastMatch = constructor;
        }
        if (lastMatch == null) {
            throw new DIRuntimeException("No applicable constructor is found for constructor injection in class '%s'", implementation.getName());
        }
        this.constructor = lastMatch;
        Annotation[][] annotations = lastMatch.getParameterAnnotations();
        this.bindingNames = new String[annotations.length];
        block3: for (int i = 0; i < annotations.length; ++i) {
            Annotation[] parameterAnnotations = annotations[i];
            for (int j = 0; j < parameterAnnotations.length; ++j) {
                Annotation annotation = parameterAnnotations[j];
                if (!annotation.annotationType().equals(Inject.class)) continue;
                Inject inject = (Inject)annotation;
                this.bindingNames[i] = inject.value();
                continue block3;
            }
        }
    }

    @Override
    public T get() {
        Class<?>[] constructorParameters = this.constructor.getParameterTypes();
        Type[] genericTypes = this.constructor.getGenericParameterTypes();
        Object[] args = new Object[constructorParameters.length];
        InjectionStack stack = this.injector.getInjectionStack();
        for (int i = 0; i < constructorParameters.length; ++i) {
            args[i] = this.value(constructorParameters[i], genericTypes[i], this.bindingNames[i], stack);
        }
        try {
            return this.constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new DIRuntimeException("Error instantiating class '%s'", (Throwable)e, this.constructor.getDeclaringClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object value(Class<?> parameter, Type genericType, String bindingName, InjectionStack stack) {
        if (Provider.class.equals(parameter)) {
            Class<?> objectClass = DIUtil.parameterClass(genericType);
            if (objectClass == null) {
                throw new DIRuntimeException("Constructor provider parameter %s must be parameterized to be usable for injection", parameter.getName());
            }
            return this.injector.getProvider(Key.get(objectClass, bindingName));
        }
        Key<?> key = DIUtil.getKeyForTypeAndGenericType(parameter, genericType, bindingName);
        stack.push(key);
        try {
            Object obj = this.injector.getInstance(key);
            return obj;
        }
        finally {
            stack.pop();
        }
    }
}

