/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen.internal;

import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.DataMap;

public class Utils {
    public static Optional<String> getMavenSrcPathForPath(Path path) {
        return Utils.getMavenSrcPathForPath(path.toAbsolutePath().toString());
    }

    public static Optional<String> getMavenSrcPathForPath(String path) {
        String testDirPath = Utils.checkDefaultMavenResourceDir(path, "test");
        if (testDirPath != null) {
            return Optional.of(testDirPath);
        }
        String mainDirPath = Utils.checkDefaultMavenResourceDir(path, "main");
        if (mainDirPath != null) {
            return Optional.of(mainDirPath);
        }
        return Optional.empty();
    }

    public static Path getRootPathForDataMap(DataMap dataMap) {
        Path resourcePath;
        if (dataMap.getConfigurationSource() == null) {
            throw new CayenneRuntimeException("Unable to create path from the unsaved DataMap", new Object[0]);
        }
        try {
            resourcePath = Path.of(dataMap.getConfigurationSource().getURL().toURI());
        }
        catch (URISyntaxException e) {
            throw new CayenneRuntimeException("Unable to create path from the DataMap source location", (Throwable)e, new Object[0]);
        }
        if (Files.isRegularFile(resourcePath, new LinkOption[0])) {
            resourcePath = resourcePath.getParent();
        }
        return resourcePath;
    }

    private static String checkDefaultMavenResourceDir(String path, String dirType) {
        String resourcePath = Utils.buildFilePath("src", dirType, "resources");
        int idx = path.indexOf(resourcePath);
        if (idx < 0) {
            return null;
        }
        return path.substring(0, idx) + Utils.buildFilePath("src", dirType, "java");
    }

    private static String buildFilePath(String ... pathElements) {
        return String.join((CharSequence)File.separator, pathElements);
    }
}

