/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.editor.ObjRelationshipTableModel;
import org.apache.cayenne.modeler.util.EntityTreeModel;
import org.apache.cayenne.modeler.util.EntityTreeRelationshipFilter;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PathChooserComboBoxCellEditor;

public class DbRelationshipPathComboBoxEditor
extends PathChooserComboBoxCellEditor<ObjRelationshipTableModel>
implements FocusListener {
    private static final int REL_TARGET_PATH_COLUMN = 2;
    private static int enterPressedCount = 0;
    private JTable table;
    private String savePath;
    private ObjRelationshipTableModel model;

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.model = (ObjRelationshipTableModel)table.getModel();
        this.row = row;
        this.table = table;
        this.treeModel = this.createTreeModelForComboBox(row);
        if (this.treeModel == null) {
            return new JLabel("You should select table for this ObjectEntity");
        }
        this.initializeCombo(this.model, row, table);
        String dbRelationshipPath = ((JTextComponent)this.comboBoxPathChooser.getEditor().getEditorComponent()).getText();
        this.previousEmbeddedLevel = dbRelationshipPath.split(Pattern.quote(".")).length;
        return this.comboBoxPathChooser;
    }

    @Override
    public Object getCellEditorValue() {
        return this.model.getValueAt(this.row, 2);
    }

    @Override
    protected void initializeCombo(ObjRelationshipTableModel model, int row, JTable table) {
        super.initializeCombo(model, row, table);
        this.comboBoxPathChooser.setSelectedItem(model.getRelationship(row).getDbRelationshipPath());
        enterPressedCount = 0;
        this.comboBoxPathChooser.setToolTipText("To choose relationship press enter two times.To choose next relationship press dot.");
        JTextComponent textEditor = (JTextComponent)this.comboBoxPathChooser.getEditor().getEditorComponent();
        textEditor.addFocusListener(this);
        this.savePath = this.model.getRelationship(row).getDbRelationshipPath().value();
    }

    @Override
    protected void enterPressed(JTable table) {
        String dbRelationshipPath = ((JTextComponent)this.comboBoxPathChooser.getEditor().getEditorComponent()).getText();
        this.changeObjEntity(dbRelationshipPath);
        Object currentNode = this.getCurrentNode(dbRelationshipPath);
        String[] pathStrings = dbRelationshipPath.split(Pattern.quote("."));
        String lastStringInPath = pathStrings[pathStrings.length - 1];
        if (lastStringInPath.equals(ModelerUtil.getObjectName(currentNode)) && currentNode instanceof DbRelationship) {
            if (enterPressedCount == 1) {
                enterPressedCount = 0;
                if (table.getCellEditor() != null) {
                    table.getCellEditor().stopCellEditing();
                    if (dbRelationshipPath.equals(this.savePath)) {
                        return;
                    }
                    DbEntity lastEntity = ((DbRelationship)currentNode).getTargetEntity();
                    if (lastEntity != null) {
                        Collection<ObjEntity> objEntities = ((DbRelationship)currentNode).getTargetEntity().getDataMap().getMappedEntities(lastEntity);
                        ObjEntity objectTarget = objEntities.isEmpty() ? null : objEntities.iterator().next();
                        this.model.getRelationship(this.row).setTargetEntityName(objectTarget);
                        this.model.setUpdatedValueAt(dbRelationshipPath, this.row, 2);
                        this.model.getRelationship(this.row).setDbRelationshipPath(dbRelationshipPath);
                    }
                    this.model.getRelationship(this.row).setMapKey(null);
                }
                table.repaint();
            }
            enterPressedCount = 1;
        }
    }

    @Override
    protected void processDotEntered() {
        super.processDotEntered();
    }

    @Override
    protected void parsePathString(char lastEnteredCharacter) {
        super.parsePathString(lastEnteredCharacter);
        String dbRelationshipPath = ((JTextComponent)this.comboBoxPathChooser.getEditor().getEditorComponent()).getText();
        this.changeObjEntity(dbRelationshipPath);
        enterPressedCount = 0;
    }

    @Override
    protected EntityTreeModel createTreeModelForComboBox(int relationshipIndexInTable) {
        if (this.model.getRelationship(relationshipIndexInTable).getSourceEntity().getDbEntity() == null) {
            return null;
        }
        EntityTreeModel treeModel = new EntityTreeModel(this.model.getRelationship(relationshipIndexInTable).getSourceEntity().getDbEntity());
        treeModel.setFilter(new EntityTreeRelationshipFilter());
        return treeModel;
    }

    @Override
    protected Object getCurrentNodeToInitializeCombo(ObjRelationshipTableModel model, int row) {
        return this.getCurrentNode(this.getPathToInitializeCombo(model, row));
    }

    @Override
    protected String getPathToInitializeCombo(ObjRelationshipTableModel model, int row) {
        String pathString = model.getRelationship(row).getDbRelationshipPath().value();
        if (pathString == null) {
            return "";
        }
        String[] pathStrings = pathString.split(Pattern.quote("."));
        String lastStringInPath = pathStrings[pathStrings.length - 1];
        return pathString.replaceAll(lastStringInPath + "$", "");
    }

    private boolean changeObjEntity(String path) {
        Object currentNode = this.getCurrentNode(path);
        if (currentNode instanceof DbEntity) {
            return false;
        }
        DbEntity lastEntity = ((DbRelationship)currentNode).getTargetEntity();
        if (lastEntity == null) {
            return false;
        }
        Collection<ObjEntity> objEntities = ((DbRelationship)currentNode).getTargetEntity().getDataMap().getMappedEntities(lastEntity);
        ObjEntity objectTarget = objEntities.isEmpty() ? null : objEntities.iterator().next();
        this.model.getRelationship(this.row).setTargetEntityName(objectTarget);
        this.table.repaint();
        return true;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        String path = this.model.getRelationship(this.row).getDbRelationshipPath().value();
        if (!this.changeObjEntity(path)) {
            JOptionPane.showMessageDialog(Application.getFrame(), "Can't set dbAttribute path. At first set target entity in dbEntity.", "Error", 0);
        }
    }
}

