/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.h2;

import java.util.List;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.SQLTreeProcessor;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslatorFactory;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.JsonType;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.h2.H2ActionBuilder;
import org.apache.cayenne.dba.h2.H2CharType;
import org.apache.cayenne.dba.h2.H2EJBQLTranslatorFactory;
import org.apache.cayenne.dba.h2.H2SQLTreeProcessor;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.resource.ResourceLocator;

public class H2Adapter
extends JdbcAdapter {
    public H2Adapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject(value="cayenne.resource_locator") ResourceLocator resourceLocator, @Inject ValueObjectTypeRegistry valueObjectTypeRegistry) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator, valueObjectTypeRegistry);
        this.setSupportsGeneratedKeys(true);
    }

    @Override
    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        super.createTableAppendColumn(sqlBuffer, column);
        if (column.isGenerated()) {
            sqlBuffer.append(" AUTO_INCREMENT");
        }
    }

    @Override
    public SQLTreeProcessor getSqlTreeProcessor() {
        return new H2SQLTreeProcessor();
    }

    @Override
    protected EJBQLTranslatorFactory createEJBQLTranslatorFactory() {
        H2EJBQLTranslatorFactory translatorFactory = new H2EJBQLTranslatorFactory();
        translatorFactory.setCaseInsensitive(this.caseInsensitiveCollations);
        return translatorFactory;
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new H2ActionBuilder(node));
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        H2CharType charType = new H2CharType();
        map.registerType(charType);
        map.registerType(new JsonType(charType, false));
    }

    @Override
    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int scale, boolean allowNulls) {
        if ("json".equalsIgnoreCase(typeName)) {
            type = 1111;
        }
        return super.buildAttribute(name, typeName, type, size, scale, allowNulls);
    }
}

