/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.ResultIterator;

public class GenericResponse
implements QueryResponse,
Serializable {
    protected List<Object> results;
    protected transient int currentIndex;

    public GenericResponse() {
        this.results = new ArrayList<Object>();
    }

    public GenericResponse(List<?> list) {
        this.results = new ArrayList<Object>(1);
        this.addResultList(list);
    }

    public GenericResponse(QueryResponse response) {
        this.results = new ArrayList<Object>(response.size());
        response.reset();
        while (response.next()) {
            if (response.isList()) {
                this.addResultList(response.currentList());
                continue;
            }
            if (response.isIterator()) {
                this.addResultIterator(response.currentIterator());
                continue;
            }
            this.addBatchUpdateCount(response.currentUpdateCount());
        }
    }

    @Override
    public List<?> firstList() {
        this.reset();
        while (this.next()) {
            if (!this.isList()) continue;
            return this.currentList();
        }
        return null;
    }

    @Override
    public ResultIterator<?> firstIterator() {
        this.reset();
        while (this.next()) {
            if (!this.isIterator()) continue;
            return this.currentIterator();
        }
        return null;
    }

    @Override
    public int[] firstUpdateCount() {
        this.reset();
        while (this.next()) {
            if (this.isList()) continue;
            return this.currentUpdateCount();
        }
        return null;
    }

    @Override
    public List<?> currentList() {
        return (List)this.results.get(this.currentIndex - 1);
    }

    @Override
    public ResultIterator<?> currentIterator() {
        return (ResultIterator)this.results.get(this.currentIndex - 1);
    }

    @Override
    public int[] currentUpdateCount() {
        return (int[])this.results.get(this.currentIndex - 1);
    }

    @Override
    public boolean isList() {
        return this.results.get(this.currentIndex - 1) instanceof List;
    }

    @Override
    public boolean isIterator() {
        return this.results.get(this.currentIndex - 1) instanceof ResultIterator;
    }

    @Override
    public boolean next() {
        return ++this.currentIndex <= this.results.size();
    }

    @Override
    public void reset() {
        this.currentIndex = 0;
    }

    @Override
    public int size() {
        return this.results.size();
    }

    public void clear() {
        this.results.clear();
    }

    public void addBatchUpdateCount(int[] resultCount) {
        if (resultCount != null) {
            this.results.add(resultCount);
        }
    }

    public void addUpdateCount(int resultCount) {
        this.results.add(new int[]{resultCount});
    }

    public void addResultList(List<?> list) {
        this.results.add(list);
    }

    public void addResultIterator(ResultIterator<?> iterator) {
        this.results.add(iterator);
    }

    public void replaceResult(Object oldResult, Object newResult) {
        int index = this.results.indexOf(oldResult);
        if (index >= 0) {
            this.results.set(index, newResult);
        }
    }
}

