/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.DBWizardAction;
import org.apache.cayenne.modeler.dialog.db.DataSourceWizard;
import org.apache.cayenne.modeler.dialog.db.MergerOptions;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.project.ProjectPath;

public class MigrateAction
extends DBWizardAction {
    public static String getActionName() {
        return "Migrate Database Schema";
    }

    public MigrateAction(Application application) {
        super(MigrateAction.getActionName(), application);
    }

    public void performAction(ActionEvent e) {
        DBConnectionInfo nodeInfo = this.preferredDataSource();
        String nodeKey = this.preferredDataSourceLabel(nodeInfo);
        DataSourceWizard connectWizard = new DataSourceWizard(this.getProjectController(), "Migrate DB Schema: Connect to Database", nodeKey, nodeInfo);
        if (!connectWizard.startupAction()) {
            return;
        }
        DataMap map = this.getProjectController().getCurrentDataMap();
        if (map == null) {
            throw new IllegalStateException("No current DataMap selected.");
        }
        new MergerOptions(this.getProjectController(), "Migrate DB Schema: Options", connectWizard.getConnectionInfo(), map).startupAction();
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.firstInstanceOf(DataMap.class) != null;
    }
}

