/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.awt.Point;
import java.util.regex.Pattern;
import org.apache.commons.beanutils2.converters.AbstractConverter;

public class PointConverter
extends AbstractConverter<Point> {
    private static final Pattern POINT_SPLIT = Pattern.compile("\\s*,\\s*");

    public PointConverter() {
    }

    public PointConverter(Point defaultValue) {
        super(defaultValue);
    }

    @Override
    protected <T> T convertToType(Class<T> type, Object value) throws Throwable {
        if (Point.class.isAssignableFrom(type)) {
            String stringValue = PointConverter.toString(value);
            if (stringValue.isEmpty()) {
                throw new IllegalArgumentException("A point cannot be empty.");
            }
            int lastCharIndex = stringValue.length() - 1;
            if (stringValue.charAt(0) != '(' || stringValue.charAt(lastCharIndex) != ')') {
                throw new IllegalArgumentException("Point coordinates must be enclosed in brackets.");
            }
            String coordinates = stringValue.substring(1, lastCharIndex);
            String[] xy = POINT_SPLIT.split(coordinates);
            if (xy.length != 2) {
                throw new IllegalArgumentException("Point must have an x coordinate, and y coordinate only, expecting the following format: (40, 200)");
            }
            int x = Integer.parseInt(xy[0]);
            int y = Integer.parseInt(xy[1]);
            return type.cast(new Point(x, y));
        }
        throw this.conversionException(type, value);
    }

    @Override
    protected Class<Point> getDefaultType() {
        return Point.class;
    }
}

