/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.exif;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.apache.commons.imaging.ImagingOverflowException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.examples.WriteExifMetadataExample;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;
import org.apache.commons.imaging.formats.jpeg.exif.AbstractExifTest;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class WriteExifMetadataExampleTest
extends AbstractExifTest {
    public static Stream<File> data() throws Exception {
        return WriteExifMetadataExampleTest.getJpegImages().stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testOddOffsets(File imageFile) throws Exception {
        Debug.debug((String)"imageFile", (Object)imageFile.getAbsoluteFile());
        File tempFile = Files.createTempFile("test", ".jpg", new FileAttribute[0]).toFile();
        Debug.debug((String)"tempFile", (Object)tempFile.getAbsoluteFile());
        try {
            boolean ignoreImageData = this.isPhilHarveyTestImage(imageFile);
            if (ignoreImageData) {
                return;
            }
            new WriteExifMetadataExample().changeExifMetadata(imageFile, tempFile);
            JpegImageParser parser = new JpegImageParser();
            ByteSource byteSource = ByteSource.file((File)tempFile);
            TiffImageMetadata tiff = parser.getExifMetadata(byteSource, null);
            for (TiffField tiffField : tiff.getAllFields()) {
                if (tiffField.isLocalValue()) continue;
                boolean isOdd = ((long)tiffField.getOffset() & 1L) == 0L;
                Assertions.assertTrue((boolean)isOdd);
            }
        }
        catch (ImagingOverflowException e) {
            Debug.debug((String)("Ignoring unavoidable ExifOverflowException: " + e.getMessage()));
            Debug.debug((String)("Error image: " + imageFile.getAbsoluteFile()));
        }
    }
}

