/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.listeners;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFilesystemAlterationListener
implements FilesystemAlterationListener {
    private final Log log = LogFactory.getLog(AbstractFilesystemAlterationListener.class);
    private final Collection<File> createdFiles = new ArrayList<File>();
    private final Collection<File> changedFiles = new ArrayList<File>();
    private final Collection<File> deletedFiles = new ArrayList<File>();
    private final Collection<File> createdDirectories = new ArrayList<File>();
    private final Collection<File> changedDirectories = new ArrayList<File>();
    private final Collection<File> deletedDirectories = new ArrayList<File>();
    private final Signal eventSignal = new Signal();
    private final Signal checkSignal = new Signal();
    protected FilesystemAlterationObserver observer;

    @Override
    public void onDirectoryCreate(File pDir) {
        this.createdDirectories.add(pDir);
    }

    @Override
    public void onDirectoryChange(File pDir) {
        this.changedDirectories.add(pDir);
    }

    @Override
    public void onDirectoryDelete(File pDir) {
        this.deletedDirectories.add(pDir);
    }

    @Override
    public void onFileCreate(File pFile) {
        this.createdFiles.add(pFile);
    }

    @Override
    public void onFileChange(File pFile) {
        this.changedFiles.add(pFile);
    }

    @Override
    public void onFileDelete(File pFile) {
        this.deletedFiles.add(pFile);
    }

    public Collection<File> getChangedDirectories() {
        return this.changedDirectories;
    }

    public Collection<File> getChangedFiles() {
        return this.changedFiles;
    }

    public Collection<File> getCreatedDirectories() {
        return this.createdDirectories;
    }

    public Collection<File> getCreatedFiles() {
        return this.createdFiles;
    }

    public Collection<File> getDeletedDirectories() {
        return this.deletedDirectories;
    }

    public Collection<File> getDeletedFiles() {
        return this.deletedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signals() {
        Signal signal;
        if (this.createdFiles.size() > 0 || this.createdDirectories.size() > 0 || this.changedFiles.size() > 0 || this.changedDirectories.size() > 0 || this.deletedFiles.size() > 0 || this.deletedDirectories.size() > 0) {
            this.log.debug((Object)"event signal");
            signal = this.eventSignal;
            synchronized (signal) {
                this.eventSignal.triggered = true;
                this.eventSignal.notifyAll();
            }
        }
        this.log.debug((Object)"check signal");
        signal = this.checkSignal;
        synchronized (signal) {
            this.checkSignal.triggered = true;
            this.checkSignal.notifyAll();
        }
    }

    @Override
    public void onStart(FilesystemAlterationObserver pObserver) {
        this.observer = pObserver;
        this.createdFiles.clear();
        this.changedFiles.clear();
        this.deletedFiles.clear();
        this.createdDirectories.clear();
        this.changedDirectories.clear();
        this.deletedDirectories.clear();
    }

    @Override
    public void onStop(FilesystemAlterationObserver pObserver) {
        this.signals();
        this.observer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEvent() throws Exception {
        Signal signal = this.eventSignal;
        synchronized (signal) {
            this.eventSignal.triggered = false;
        }
        this.log.debug((Object)"waiting for change");
        if (!this.waitForSignal(this.eventSignal, 10)) {
            throw new Exception("timeout");
        }
    }

    public void waitForFirstCheck() throws Exception {
        this.log.debug((Object)"waiting for first check");
        if (!this.waitForSignal(this.checkSignal, 10)) {
            throw new Exception("timeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCheck() throws Exception {
        Signal signal = this.checkSignal;
        synchronized (signal) {
            this.checkSignal.triggered = false;
        }
        this.log.debug((Object)"waiting for check");
        if (!this.waitForSignal(this.checkSignal, 10)) {
            throw new Exception("timeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForSignal(Signal pSignal, int pSecondsTimeout) {
        int i = 0;
        while (true) {
            Signal signal = pSignal;
            synchronized (signal) {
                if (pSignal.triggered) {
                    pSignal.triggered = false;
                    break;
                }
                try {
                    pSignal.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (++i > pSecondsTimeout) {
                    this.log.error((Object)("timeout after " + pSecondsTimeout + "s"));
                    return false;
                }
            }
        }
        return true;
    }

    private static final class Signal {
        public boolean triggered;

        private Signal() {
        }
    }
}

