/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.ODEIntegrator;
import org.apache.commons.math3.ode.TestProblem1;
import org.apache.commons.math3.ode.TestProblem2;
import org.apache.commons.math3.ode.TestProblem3;
import org.apache.commons.math3.ode.TestProblem4;
import org.apache.commons.math3.ode.TestProblem5;
import org.apache.commons.math3.ode.TestProblem6;
import org.apache.commons.math3.ode.TestProblemAbstract;
import org.apache.commons.math3.ode.TestProblemHandler;
import org.apache.commons.math3.ode.events.EventHandler;
import org.apache.commons.math3.ode.nonstiff.ThreeEighthesIntegrator;
import org.apache.commons.math3.ode.sampling.StepHandler;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class ThreeEighthesIntegratorTest {
    @Test(expected=DimensionMismatchException.class)
    public void testDimensionCheck() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        new ThreeEighthesIntegrator(0.01).integrate((FirstOrderDifferentialEquations)pb, 0.0, new double[pb.getDimension() + 10], 1.0, new double[pb.getDimension() + 10]);
        Assert.fail((String)"an exception should have been thrown");
    }

    @Test
    public void testDecreasingSteps() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        for (TestProblemAbstract pb : new TestProblemAbstract[]{new TestProblem1(), new TestProblem2(), new TestProblem3(), new TestProblem4(), new TestProblem5(), new TestProblem6()}) {
            double previousValueError = Double.NaN;
            double previousTimeError = Double.NaN;
            for (int i = 4; i < 10; ++i) {
                double step = (pb.getFinalTime() - pb.getInitialTime()) * FastMath.pow((double)2.0, (int)(-i));
                ThreeEighthesIntegrator integ = new ThreeEighthesIntegrator(step);
                TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
                integ.addStepHandler((StepHandler)handler);
                EventHandler[] functions = pb.getEventsHandlers();
                for (int l = 0; l < functions.length; ++l) {
                    integ.addEventHandler(functions[l], Double.POSITIVE_INFINITY, 1.0E-6 * step, 1000);
                }
                double stopTime = integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
                if (functions.length == 0) {
                    Assert.assertEquals((double)pb.getFinalTime(), (double)stopTime, (double)1.0E-10);
                }
                double error = handler.getMaximalValueError();
                if (i > 4) {
                    Assert.assertTrue((error < 1.01 * FastMath.abs((double)previousValueError) ? 1 : 0) != 0);
                }
                previousValueError = error;
                double timeError = handler.getMaximalTimeError();
                if (i > 4) {
                    Assert.assertTrue((timeError <= FastMath.abs((double)previousTimeError) ? 1 : 0) != 0);
                }
                previousTimeError = timeError;
            }
        }
    }

    @Test
    public void testSmallStep() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        double step = (pb.getFinalTime() - pb.getInitialTime()) * 0.001;
        ThreeEighthesIntegrator integ = new ThreeEighthesIntegrator(step);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertTrue((handler.getLastError() < 2.0E-13 ? 1 : 0) != 0);
        Assert.assertTrue((handler.getMaximalValueError() < 4.0E-12 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)1.0E-12);
        Assert.assertEquals((Object)"3/8", (Object)integ.getName());
    }

    @Test
    public void testBigStep() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        double step = (pb.getFinalTime() - pb.getInitialTime()) * 0.2;
        ThreeEighthesIntegrator integ = new ThreeEighthesIntegrator(step);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertTrue((handler.getLastError() > 4.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((handler.getMaximalValueError() > 0.005 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)1.0E-12);
    }

    @Test
    public void testBackward() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem5 pb = new TestProblem5();
        double step = FastMath.abs((double)(pb.getFinalTime() - pb.getInitialTime())) * 0.001;
        ThreeEighthesIntegrator integ = new ThreeEighthesIntegrator(step);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertTrue((handler.getLastError() < 5.0E-10 ? 1 : 0) != 0);
        Assert.assertTrue((handler.getMaximalValueError() < 7.0E-10 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)1.0E-12);
        Assert.assertEquals((Object)"3/8", (Object)integ.getName());
    }

    @Test
    public void testKepler() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem3 pb = new TestProblem3(0.9);
        double step = (pb.getFinalTime() - pb.getInitialTime()) * 3.0E-4;
        ThreeEighthesIntegrator integ = new ThreeEighthesIntegrator(step);
        integ.addStepHandler((StepHandler)new KeplerHandler(pb));
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
    }

    @Test
    public void testStepSize() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double step = 1.23456;
        ThreeEighthesIntegrator integ = new ThreeEighthesIntegrator(1.23456);
        integ.addStepHandler(new StepHandler(){

            public void handleStep(StepInterpolator interpolator, boolean isLast) {
                if (!isLast) {
                    Assert.assertEquals((double)1.23456, (double)(interpolator.getCurrentTime() - interpolator.getPreviousTime()), (double)1.0E-12);
                }
            }

            public void init(double t0, double[] y0, double t) {
            }
        });
        integ.integrate(new FirstOrderDifferentialEquations(){

            public void computeDerivatives(double t, double[] y, double[] dot) {
                dot[0] = 1.0;
            }

            public int getDimension() {
                return 1;
            }
        }, 0.0, new double[]{0.0}, 5.0, new double[1]);
    }

    private static class KeplerHandler
    implements StepHandler {
        private TestProblem3 pb;
        private double maxError = 0.0;

        public KeplerHandler(TestProblem3 pb) {
            this.pb = pb;
            this.maxError = 0.0;
        }

        public void init(double t0, double[] y0, double t) {
            this.maxError = 0.0;
        }

        public void handleStep(StepInterpolator interpolator, boolean isLast) throws MaxCountExceededException {
            double dy;
            double[] theoreticalY;
            double[] interpolatedY = interpolator.getInterpolatedState();
            double dx = interpolatedY[0] - (theoreticalY = this.pb.computeTheoreticalState(interpolator.getCurrentTime()))[0];
            double error = dx * dx + (dy = interpolatedY[1] - theoreticalY[1]) * dy;
            if (error > this.maxError) {
                this.maxError = error;
            }
            if (isLast) {
                Assert.assertTrue((this.maxError > 0.005 ? 1 : 0) != 0);
            }
        }
    }
}

