/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.vector.jacobian;

import java.util.ArrayList;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.optim.nonlinear.vector.ModelFunction;
import org.apache.commons.math3.optim.nonlinear.vector.ModelFunctionJacobian;
import org.apache.commons.math3.stat.regression.SimpleRegression;

@Deprecated
class StraightLineProblem {
    private final ArrayList<double[]> points = new ArrayList();
    private final double sigma;

    public StraightLineProblem(double error) {
        this.sigma = error;
    }

    public void addPoint(double px, double py) {
        this.points.add(new double[]{px, py});
    }

    public double[] x() {
        double[] v = new double[this.points.size()];
        for (int i = 0; i < this.points.size(); ++i) {
            double[] p = this.points.get(i);
            v[i] = p[0];
        }
        return v;
    }

    public double[] y() {
        double[] v = new double[this.points.size()];
        for (int i = 0; i < this.points.size(); ++i) {
            double[] p = this.points.get(i);
            v[i] = p[1];
        }
        return v;
    }

    public double[] target() {
        return this.y();
    }

    public double[] weight() {
        double weight = 1.0 / (this.sigma * this.sigma);
        double[] w = new double[this.points.size()];
        for (int i = 0; i < this.points.size(); ++i) {
            w[i] = weight;
        }
        return w;
    }

    public ModelFunction getModelFunction() {
        return new ModelFunction(new MultivariateVectorFunction(){

            public double[] value(double[] params) {
                Model line = new Model(params[0], params[1]);
                double[] model = new double[StraightLineProblem.this.points.size()];
                for (int i = 0; i < StraightLineProblem.this.points.size(); ++i) {
                    double[] p = (double[])StraightLineProblem.this.points.get(i);
                    model[i] = line.value(p[0]);
                }
                return model;
            }
        });
    }

    public ModelFunctionJacobian getModelFunctionJacobian() {
        return new ModelFunctionJacobian(new MultivariateMatrixFunction(){

            public double[][] value(double[] point) {
                return StraightLineProblem.this.jacobian(point);
            }
        });
    }

    public double[] solve() {
        SimpleRegression regress = new SimpleRegression(true);
        for (double[] d : this.points) {
            regress.addData(d[0], d[1]);
        }
        double[] result = new double[]{regress.getSlope(), regress.getIntercept()};
        return result;
    }

    private double[][] jacobian(double[] params) {
        double[][] jacobian = new double[this.points.size()][2];
        for (int i = 0; i < this.points.size(); ++i) {
            double[] p = this.points.get(i);
            jacobian[i][0] = p[0];
            jacobian[i][1] = 1.0;
        }
        return jacobian;
    }

    public static class Model
    implements UnivariateFunction {
        final double a;
        final double b;

        public Model(double a, double b) {
            this.a = a;
            this.b = b;
        }

        public double value(double x) {
            return this.a * x + this.b;
        }
    }
}

