/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import org.apache.commons.math3.ExtendedFieldElementAbstractTest;
import org.apache.commons.math3.util.Decimal64;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Decimal64Test
extends ExtendedFieldElementAbstractTest<Decimal64> {
    public static final double X = 1.2345;
    public static final Decimal64 PLUS_X = new Decimal64(1.2345);
    public static final Decimal64 MINUS_X = new Decimal64(-1.2345);
    public static final double Y = 6.789;
    public static final Decimal64 PLUS_Y = new Decimal64(6.789);
    public static final Decimal64 MINUS_Y = new Decimal64(-6.789);
    public static final Decimal64 PLUS_ZERO = new Decimal64(0.0);
    public static final Decimal64 MINUS_ZERO = new Decimal64(-0.0);

    @Override
    protected Decimal64 build(double x) {
        return new Decimal64(x);
    }

    @Test
    public void testAdd() {
        Decimal64 expected = new Decimal64(8.0235);
        Decimal64 actual = PLUS_X.add(PLUS_Y);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = PLUS_Y.add(PLUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = new Decimal64(-5.5545);
        actual = PLUS_X.add(MINUS_Y);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_Y.add(PLUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = new Decimal64(-8.0235);
        actual = MINUS_X.add(MINUS_Y);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_Y.add(MINUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = Decimal64.POSITIVE_INFINITY;
        actual = PLUS_X.add(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.POSITIVE_INFINITY.add(PLUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_X.add(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.POSITIVE_INFINITY.add(MINUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.POSITIVE_INFINITY.add(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = Decimal64.NEGATIVE_INFINITY;
        actual = PLUS_X.add(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.add(PLUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.add(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_X.add(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.add(MINUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = Decimal64.NAN;
        actual = Decimal64.POSITIVE_INFINITY.add(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.add(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = PLUS_X.add(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.add(PLUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_X.add(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.add(MINUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.POSITIVE_INFINITY.add(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.add(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.add(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.add(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.add(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSubtract() {
        Decimal64 expected = new Decimal64(-5.5545);
        Decimal64 actual = PLUS_X.subtract(PLUS_Y);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = new Decimal64(8.0235);
        actual = PLUS_X.subtract(MINUS_Y);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = new Decimal64(-8.0235);
        actual = MINUS_X.subtract(PLUS_Y);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = new Decimal64(5.5545);
        actual = MINUS_X.subtract(MINUS_Y);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = Decimal64.NEGATIVE_INFINITY;
        actual = PLUS_X.subtract(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_X.subtract(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.subtract(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = Decimal64.POSITIVE_INFINITY;
        actual = PLUS_X.subtract(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_X.subtract(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.POSITIVE_INFINITY.subtract(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = Decimal64.NAN;
        actual = Decimal64.POSITIVE_INFINITY.subtract(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.subtract(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = PLUS_X.subtract(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.subtract(PLUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_X.subtract(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.subtract(MINUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.POSITIVE_INFINITY.subtract(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.subtract(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.subtract(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.subtract(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.subtract(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNegate() {
        Decimal64 expected = MINUS_X;
        Decimal64 actual = PLUS_X.negate();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = PLUS_X;
        actual = MINUS_X.negate();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = MINUS_ZERO;
        actual = PLUS_ZERO.negate();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = PLUS_ZERO;
        actual = MINUS_ZERO.negate();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = Decimal64.POSITIVE_INFINITY;
        actual = Decimal64.NEGATIVE_INFINITY.negate();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = Decimal64.NEGATIVE_INFINITY;
        actual = Decimal64.POSITIVE_INFINITY.negate();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = Decimal64.NAN;
        actual = Decimal64.NAN.negate();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMultiply() {
        Decimal64 expected = new Decimal64(8.3810205);
        Decimal64 actual = PLUS_X.multiply(PLUS_Y);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = PLUS_Y.multiply(PLUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = new Decimal64(-8.3810205);
        actual = PLUS_X.multiply(MINUS_Y);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_Y.multiply(PLUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = new Decimal64(8.3810205);
        actual = MINUS_X.multiply(MINUS_Y);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_Y.multiply(MINUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = Decimal64.POSITIVE_INFINITY;
        actual = PLUS_X.multiply(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.POSITIVE_INFINITY.multiply(PLUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_X.multiply(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.multiply(MINUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.POSITIVE_INFINITY.multiply(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.multiply(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = Decimal64.NEGATIVE_INFINITY;
        actual = PLUS_X.multiply(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.multiply(PLUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_X.multiply(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.POSITIVE_INFINITY.multiply(MINUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.POSITIVE_INFINITY.multiply(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.multiply(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = Decimal64.NAN;
        actual = PLUS_X.multiply(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.multiply(PLUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_X.multiply(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.multiply(MINUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.POSITIVE_INFINITY.multiply(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.multiply(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.multiply(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.multiply(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.multiply(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDivide() {
        Decimal64 expected = new Decimal64(0.1818382677861246);
        Decimal64 actual = PLUS_X.divide(PLUS_Y);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = new Decimal64(-0.1818382677861246);
        actual = PLUS_X.divide(MINUS_Y);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = new Decimal64(-0.1818382677861246);
        actual = MINUS_X.divide(PLUS_Y);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = new Decimal64(0.1818382677861246);
        actual = MINUS_X.divide(MINUS_Y);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = PLUS_ZERO;
        actual = PLUS_X.divide(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_X.divide(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = MINUS_ZERO;
        actual = MINUS_X.divide(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = PLUS_X.divide(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = Decimal64.POSITIVE_INFINITY;
        actual = Decimal64.POSITIVE_INFINITY.divide(PLUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.divide(MINUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = PLUS_X.divide(PLUS_ZERO);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_X.divide(MINUS_ZERO);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = Decimal64.NEGATIVE_INFINITY;
        actual = Decimal64.POSITIVE_INFINITY.divide(MINUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.divide(PLUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = PLUS_X.divide(MINUS_ZERO);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_X.divide(PLUS_ZERO);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = Decimal64.NAN;
        actual = Decimal64.POSITIVE_INFINITY.divide(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.POSITIVE_INFINITY.divide(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.divide(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.divide(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = PLUS_X.divide(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.divide(PLUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_X.divide(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.divide(MINUS_X);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.POSITIVE_INFINITY.divide(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.divide(Decimal64.POSITIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NEGATIVE_INFINITY.divide(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.divide(Decimal64.NEGATIVE_INFINITY);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Decimal64.NAN.divide(Decimal64.NAN);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = PLUS_ZERO.divide(PLUS_ZERO);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = PLUS_ZERO.divide(MINUS_ZERO);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_ZERO.divide(PLUS_ZERO);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = MINUS_ZERO.divide(MINUS_ZERO);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testReciprocal() {
        Decimal64 expected = new Decimal64(0.8100445524503849);
        Decimal64 actual = PLUS_X.reciprocal();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = new Decimal64(-0.8100445524503849);
        actual = MINUS_X.reciprocal();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = PLUS_ZERO;
        actual = Decimal64.POSITIVE_INFINITY.reciprocal();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = MINUS_ZERO;
        actual = Decimal64.NEGATIVE_INFINITY.reciprocal();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testIsInfinite() {
        Assert.assertFalse((boolean)MINUS_X.isInfinite());
        Assert.assertFalse((boolean)PLUS_X.isInfinite());
        Assert.assertFalse((boolean)MINUS_Y.isInfinite());
        Assert.assertFalse((boolean)PLUS_Y.isInfinite());
        Assert.assertFalse((boolean)Decimal64.NAN.isInfinite());
        Assert.assertTrue((boolean)Decimal64.NEGATIVE_INFINITY.isInfinite());
        Assert.assertTrue((boolean)Decimal64.POSITIVE_INFINITY.isInfinite());
    }

    @Test
    public void testIsNaN() {
        Assert.assertFalse((boolean)MINUS_X.isNaN());
        Assert.assertFalse((boolean)PLUS_X.isNaN());
        Assert.assertFalse((boolean)MINUS_Y.isNaN());
        Assert.assertFalse((boolean)PLUS_Y.isNaN());
        Assert.assertFalse((boolean)Decimal64.NEGATIVE_INFINITY.isNaN());
        Assert.assertFalse((boolean)Decimal64.POSITIVE_INFINITY.isNaN());
        Assert.assertTrue((boolean)Decimal64.NAN.isNaN());
    }
}

