/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.optim.nonlinear.scalar.noderiv;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.DoublePredicate;
import java.util.function.UnaryOperator;
import org.apache.commons.math4.legacy.analysis.MultivariateFunction;
import org.apache.commons.math4.legacy.optim.PointValuePair;
import org.apache.commons.math4.legacy.optim.nonlinear.scalar.noderiv.Simplex;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousUniformSampler;
import org.apache.commons.rng.simple.RandomSource;

public class HedarFukushimaTransform
implements Simplex.TransformFactory {
    private final double sigma;
    private final ContinuousSampler alphaSampler;
    private final boolean noShrink;

    public HedarFukushimaTransform(double sigma, UniformRandomProvider rng) {
        if (sigma <= 0.0 || sigma > 1.0) {
            throw new IllegalArgumentException("Shrink factor out of range: " + sigma);
        }
        this.sigma = sigma;
        this.alphaSampler = ContinuousUniformSampler.of((UniformRandomProvider)rng, (double)0.9, (double)1.1);
        this.noShrink = sigma == 1.0;
    }

    public HedarFukushimaTransform(double sigma) {
        this(sigma, (UniformRandomProvider)RandomSource.KISS.create());
    }

    public HedarFukushimaTransform() {
        this(1.0);
    }

    @Override
    public UnaryOperator<Simplex> create(MultivariateFunction evaluationFunction, Comparator<PointValuePair> comparator, DoublePredicate saAcceptance) {
        if (saAcceptance == null) {
            throw new IllegalArgumentException("Missing SA acceptance test");
        }
        return original -> this.transform((Simplex)original, saAcceptance, evaluationFunction, comparator);
    }

    private Simplex transform(Simplex original, DoublePredicate sa, MultivariateFunction eval, Comparator<PointValuePair> comp) {
        int size = original.getSize();
        PointValuePair best = original.get(0);
        double bestValue = (Double)best.getValue();
        for (int k = 1; k < size; ++k) {
            boolean candidateIsAccepted;
            List<PointValuePair> reflected = this.reflectPoints(original, k, eval);
            Collections.sort(reflected, comp);
            PointValuePair candidate = reflected.get(0);
            boolean candidateIsBetter = comp.compare(candidate, best) < 0;
            boolean bl = candidateIsAccepted = candidateIsBetter || sa.test((Double)candidate.getValue() - bestValue);
            if (!candidateIsAccepted) continue;
            return original.replaceLast(reflected);
        }
        return this.noShrink ? original : original.shrink(this.sigma, eval);
    }

    private List<PointValuePair> reflectPoints(Simplex simplex, int nPoints, MultivariateFunction eval) {
        int size = simplex.getSize();
        if (nPoints < 1 || nPoints >= size) {
            throw new IllegalArgumentException("Out of range: " + nPoints);
        }
        int nCentroid = size - nPoints;
        List<PointValuePair> centroidList = simplex.asList(0, nCentroid);
        List<PointValuePair> reflectList = simplex.asList(nCentroid, size);
        double[] centroid = Simplex.centroid(centroidList);
        ArrayList<PointValuePair> reflected = new ArrayList<PointValuePair>(nPoints);
        for (int i = 0; i < reflectList.size(); ++i) {
            reflected.add(this.newReflectedPoint(reflectList.get(i), centroid, eval));
        }
        return reflected;
    }

    private PointValuePair newReflectedPoint(PointValuePair point, double[] centroid, MultivariateFunction eval) {
        double alpha = this.alphaSampler.sample();
        return Simplex.newPoint(centroid, -alpha, point.getPoint(), eval);
    }

    public String toString() {
        return "Hedar-Fukushima [s=" + this.sigma + "]";
    }
}

