/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.ProviderTestConfig;
import org.apache.commons.vfs2.cache.SoftRefFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;

public abstract class AbstractProviderTestConfig
extends AbstractProviderTestCase
implements ProviderTestConfig {
    public static final String MIME_TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String MIME_TYPE_APPLICATION_X_TAR = "application/x-tar";
    public static final String MIME_TYPE_APPLICATION_ZIP = "application/zip";
    private FilesCache filesCache;

    public static String getLocalCanonicalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static String getLocalHostUriString(String scheme, int socketPort) throws UnknownHostException {
        return scheme + "://" + AbstractProviderTestConfig.getLocalCanonicalHostName() + ":" + socketPort;
    }

    protected FilesCache createFilesCache() {
        return new SoftRefFilesCache();
    }

    @Override
    public DefaultFileSystemManager getDefaultFileSystemManager() {
        return new DefaultFileSystemManager();
    }

    @Override
    public final FilesCache getFilesCache() {
        if (this.filesCache == null) {
            this.filesCache = this.createFilesCache();
        }
        return this.filesCache;
    }

    @Override
    public boolean isFileSystemRootAccessible() {
        return true;
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
    }

    public void tearDown() throws Exception {
        if (this.filesCache != null) {
            this.filesCache.close();
            Thread.sleep(20L);
        }
    }
}

