/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.nested;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.taglib.nested.NestedNameSupport;
import org.apache.struts.taglib.nested.NestedPropertyHelper;

public class NestedRootTag
extends BodyTagSupport
implements NestedNameSupport {
    private String name = null;
    private String originalName = "";
    private String originalNesting = "";
    private String originalNestingName = "";

    public String getProperty() {
        return "";
    }

    public void setProperty(String property) {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        this.originalName = this.name;
        this.originalNesting = NestedPropertyHelper.getCurrentProperty(request);
        this.originalNestingName = NestedPropertyHelper.getCurrentName(request, this);
        if (this.name != null) {
            NestedPropertyHelper.setProperty(request, "");
            NestedPropertyHelper.setName(request, this.name);
        }
        return 2;
    }

    public int doAfterBody() throws JspException {
        if (this.bodyContent != null) {
            TagUtils.getInstance().writePrevious(this.pageContext, this.bodyContent.getString());
            this.bodyContent.clearBody();
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (this.originalNesting == null) {
            NestedPropertyHelper.deleteReference(request);
        } else {
            NestedPropertyHelper.setName(request, this.originalNestingName);
            NestedPropertyHelper.setProperty(request, this.originalNesting);
        }
        this.name = this.originalName;
        return 6;
    }

    public void release() {
        super.release();
        this.name = null;
        this.originalName = null;
        this.originalNesting = null;
        this.originalNestingName = null;
    }
}

