/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.tksvmlight;

import com.google.common.annotations.Beta;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Locale;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.encoder.CleartkEncoderException;
import org.cleartk.ml.encoder.features.BooleanEncoder;
import org.cleartk.ml.encoder.features.FeatureEncoder;
import org.cleartk.ml.encoder.features.NameNumber;
import org.cleartk.ml.encoder.features.NumberEncoder;
import org.cleartk.ml.encoder.features.StringEncoder;
import org.cleartk.ml.encoder.outcome.BooleanToBooleanOutcomeEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.DataWriter_ImplBase;
import org.cleartk.ml.tksvmlight.TreeFeatureVector;
import org.cleartk.ml.tksvmlight.TreeFeatureVectorFeaturesEncoder;
import org.cleartk.ml.tksvmlight.TreeKernelSvmBooleanOutcomeClassifier;
import org.cleartk.ml.tksvmlight.TreeKernelSvmBooleanOutcomeClassifierBuilder;
import org.cleartk.ml.util.featurevector.FeatureVector;

@Beta
public abstract class TreeKernelSvmBooleanOutcomeDataWriter
extends DataWriter_ImplBase<TreeKernelSvmBooleanOutcomeClassifierBuilder<TreeKernelSvmBooleanOutcomeClassifier>, TreeFeatureVector, Boolean, Boolean> {
    public TreeKernelSvmBooleanOutcomeDataWriter(File outputDirectory) throws FileNotFoundException {
        super(outputDirectory);
        TreeFeatureVectorFeaturesEncoder myFeaturesEncoder = new TreeFeatureVectorFeaturesEncoder();
        myFeaturesEncoder.addEncoder((FeatureEncoder<NameNumber>)new NumberEncoder());
        myFeaturesEncoder.addEncoder((FeatureEncoder<NameNumber>)new BooleanEncoder());
        myFeaturesEncoder.addEncoder((FeatureEncoder<NameNumber>)new StringEncoder());
        this.setFeaturesEncoder(myFeaturesEncoder);
        this.setOutcomeEncoder((OutcomeEncoder)new BooleanToBooleanOutcomeEncoder());
    }

    public static String createString(TreeFeatureVector features) throws CleartkProcessingException {
        StringBuffer output = new StringBuffer();
        for (String tree : features.getTrees().values()) {
            output.append(String.format(Locale.US, " |BT| %s", tree));
        }
        if (!features.getTrees().isEmpty()) {
            output.append(" |ET|");
        }
        for (FeatureVector.Entry entry : features.getFeatures()) {
            if (Double.isInfinite(entry.value) || Double.isNaN(entry.value)) {
                throw CleartkEncoderException.invalidFeatureVectorValue((int)entry.index, (double)entry.value);
            }
            output.append(String.format(Locale.US, " %d:%.7f", entry.index, entry.value));
        }
        return output.toString();
    }

    public void writeEncoded(TreeFeatureVector features, Boolean outcome) throws CleartkProcessingException {
        StringBuffer output = new StringBuffer();
        if (outcome == null) {
            output.append("0");
        } else if (outcome.booleanValue()) {
            output.append("+1");
        } else {
            output.append("-1");
        }
        output.append(TreeKernelSvmBooleanOutcomeDataWriter.createString(features));
        this.trainingDataWriter.println(output);
    }
}

