/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.svmlight;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.cleartk.ml.sigmoid.LinWengPlatt;
import org.cleartk.ml.sigmoid.Sigmoid;
import org.cleartk.ml.svmlight.model.SvmLightModel;
import org.cleartk.ml.util.featurevector.FeatureVector;
import org.cleartk.ml.util.featurevector.InvalidFeatureVectorValueException;
import org.cleartk.ml.util.featurevector.SparseFeatureVector;

public class FitSigmoid {
    public static Sigmoid fit(File svmlightModelFile, File trainingDataFile) throws LinWengPlatt.ConvergenceFailure, IOException, InvalidFeatureVectorValueException {
        SvmLightModel model = SvmLightModel.fromFile(svmlightModelFile);
        BufferedReader r = new BufferedReader(new FileReader(trainingDataFile));
        int lines = 0;
        while (r.readLine() != null) {
            ++lines;
        }
        r.close();
        boolean[] labels = new boolean[lines];
        double[] decisionValues = new double[lines];
        int i = 0;
        r = new BufferedReader(new FileReader(trainingDataFile));
        String line = r.readLine();
        while (line != null) {
            TrainingInstance ti = FitSigmoid.parseTI(line.trim());
            labels[i] = ti.getLabel();
            decisionValues[i] = model.evaluate(ti.getFeatureVector());
            ++i;
            line = r.readLine();
        }
        r.close();
        return LinWengPlatt.fit((double[])decisionValues, (boolean[])labels);
    }

    private static TrainingInstance parseTI(String line) throws InvalidFeatureVectorValueException {
        String[] fields = line.split(" ");
        boolean label = fields[0].trim().equals("+1");
        SparseFeatureVector fv = new SparseFeatureVector();
        for (int i = 1; i < fields.length; ++i) {
            String[] parts = fields[i].split(":");
            int featureIndex = Integer.valueOf(parts[0]);
            double featureValue = Double.valueOf(parts[1]);
            fv.set(featureIndex, featureValue);
        }
        return new TrainingInstance(label, (FeatureVector)fv);
    }

    private static class TrainingInstance {
        private boolean label;
        private FeatureVector featureVector;

        public TrainingInstance(boolean label, FeatureVector featureVector) {
            this.label = label;
            this.featureVector = featureVector;
        }

        public boolean getLabel() {
            return this.label;
        }

        public FeatureVector getFeatureVector() {
            return this.featureVector;
        }
    }
}

