/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.cr;

import java.util.Date;
import org.apache.log4j.Logger;

public class NegExAnnotation {
    static Logger LOGGER = Logger.getLogger(NegExAnnotation.class);
    String lineNumber;
    String entityCoveredText;
    String sentenceText;
    String polarity;
    String possible;
    String temporality;
    String experiencer;
    String begin;
    String end;

    public NegExAnnotation(String lineWithAnnotation) {
        String rest;
        int numRequiredFields;
        String s = lineWithAnnotation.trim();
        if (s.length() == 0) {
            throw new RuntimeException("no annotation or sentence data found");
        }
        String[] fields = lineWithAnnotation.split("\t");
        if (fields.length < (numRequiredFields = 4)) {
            throw new RuntimeException("Not enough fields on line '" + lineWithAnnotation + "', need at least " + numRequiredFields + "fields.");
        }
        this.lineNumber = fields[0].trim();
        String INCORRECT_LINE1 = "OSTEOCHONDRAL IRREGULARITY WITHIN THE 45 DEGREE FLEXION ZONE  OF THE LATERAL FEMORAL CONDYLE COMPATIBLE WITH OSTEOCHONDRAL  LESION. INCREASED SCLEROSIS WITHIN THIS REGION";
        String CORRECTED_LINE1 = "OSTEOCHONDRAL IRREGULARITY WITHIN THE 45 DEGREE FLEXION ZONE  OF THE LATERAL FEMORAL CONDYLE COMPATIBLE WITH OSTEOCHONDRAL  LESION.";
        this.entityCoveredText = fields[1].trim();
        if (this.entityCoveredText.toLowerCase().equals(INCORRECT_LINE1.toLowerCase())) {
            this.entityCoveredText = CORRECTED_LINE1;
        }
        if (this.entityCoveredText.length() < 1) {
            throw new RuntimeException("Error parsing entityCoveredText from line '" + lineWithAnnotation + "'");
        }
        if (this.entityCoveredText.startsWith("Pharynx good.")) {
            this.entityCoveredText = "Pharynx good.";
        }
        if (this.entityCoveredText.toLowerCase().startsWith("neck:  supple.")) {
            this.entityCoveredText = this.entityCoveredText.substring(0, "NECK:  Supple.".length());
        }
        String INCORRECT_LINE3 = "RIGHT THYROID:  SATISFACTORY FOR INTERPRETATION.  NEGATIVE FOR MALIGNANT CELLS.  COLLOID NODULE";
        String CORRECTED_LINE3 = "RIGHT THYROID:  SATISFACTORY FOR INTERPRETATION.";
        if (this.entityCoveredText.toLowerCase().equals(INCORRECT_LINE3.toLowerCase())) {
            this.entityCoveredText = CORRECTED_LINE3;
        }
        if (this.entityCoveredText.toLowerCase().equals("tolerating p.o. intake")) {
            LOGGER.warn((Object)"Unable to handle at this time because gold standard is incorrect");
            throw new RuntimeException("Skip this one as gold standard has a problem");
        }
        this.sentenceText = fields[2].trim();
        String INCORRECT_LINE2 = "The patient states   that she was able to tolerate some p.o.";
        String CORRECTED_LINE2 = "The patient states   that she was able to tolerate some p.o. fluids";
        if (this.sentenceText.equals(INCORRECT_LINE2)) {
            this.sentenceText = CORRECTED_LINE2;
        }
        int position = this.sentenceText.toLowerCase().indexOf(this.entityCoveredText.toLowerCase());
        char DQUOTE = '\"';
        if (position < 0) {
            int last;
            if (this.entityCoveredText.charAt(0) == DQUOTE) {
                this.entityCoveredText = this.entityCoveredText.substring(1);
            }
            if (this.entityCoveredText.charAt(last = this.entityCoveredText.length() - 1) == DQUOTE) {
                this.entityCoveredText = this.entityCoveredText.substring(0, last);
            }
            if ((position = this.sentenceText.toLowerCase().indexOf(this.entityCoveredText.toLowerCase())) < 0) {
                throw new RuntimeException("Did not find entity text '" + this.entityCoveredText + "' within sentence '" + this.sentenceText + "'");
            }
        }
        if ((rest = this.sentenceText.substring(position + 1)).contains(this.entityCoveredText)) {
            LOGGER.error((Object)("Assuming 2nd occurrence is correct occurenence of '" + this.entityCoveredText + "'."));
            position = this.sentenceText.toLowerCase().indexOf(this.entityCoveredText.toLowerCase(), position + 1);
        }
        this.begin = position + "";
        this.end = position + this.entityCoveredText.length() + "";
        String field3LowerCase = fields[3].trim().toLowerCase();
        if (field3LowerCase.equals("possible")) {
            this.polarity = "1";
            this.possible = "1";
        } else if (field3LowerCase.equals("affirmed")) {
            this.polarity = "1";
            this.possible = "0";
        } else if (field3LowerCase.equals("negated")) {
            this.polarity = "-1";
            this.possible = "0";
        }
    }

    public String toString() {
        String s = this.entityCoveredText + " (" + this.begin + ", " + this.end + ")  polarity=" + this.polarity + " possible=" + this.possible;
        s = s + "\nin '" + this.sentenceText + "'";
        return s;
    }

    public static void main(String[] args) {
        String line = "2\tpulmonic regurgitation\tThere is trace PULMONIC REGURGITATION.\tAffirmed";
        NegExAnnotation anno = new NegExAnnotation(line);
        System.out.println("Was able to create NegExAnnotation successfully at " + new Date());
        System.out.println(anno.toString());
    }
}

