/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Scanner;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.encoder.outcome.StringToIntegerOutcomeEncoder;
import org.cleartk.ml.liblinear.LibLinearStringOutcomeDataWriter;
import org.cleartk.ml.liblinear.encoder.FeatureNodeArrayEncoder;

public class EncoderReusingDataWriter
extends LibLinearStringOutcomeDataWriter {
    public EncoderReusingDataWriter(File outputDirectory) throws FileNotFoundException {
        super(outputDirectory);
        File outputEncoderFile;
        File encoderFile = new File(outputDirectory, "encoders.ser");
        if (encoderFile.exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(encoderFile));
                this.setFeaturesEncoder((FeaturesEncoder)((FeatureNodeArrayEncoder)ois.readObject()));
                ois.close();
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
                throw new FileNotFoundException("Problem loading encoder from encoders.ser");
            }
        }
        if ((outputEncoderFile = new File(outputDirectory, "outcome-lookup.txt")).exists()) {
            StringToIntegerOutcomeEncoder outcomeEncoder = new StringToIntegerOutcomeEncoder();
            try (Scanner scanner = new Scanner(outputEncoderFile);){
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    String[] ind_val = line.split(" ");
                    outcomeEncoder.encode(ind_val[1]);
                }
            }
            this.setOutcomeEncoder((OutcomeEncoder)outcomeEncoder);
        }
    }
}

