/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.apache.ctakes.assertion.attributes.features.selection.Chi2FeatureSelection;
import org.apache.ctakes.assertion.attributes.features.selection.FeatureSelection;
import org.apache.ctakes.assertion.medfacts.cleartk.AssertionCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.AboveLeftFragmentExtractor;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.AssertionAboveLeftTreeExtractor;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.AssertionDependencyTreeExtractor;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.ContextWordWindowExtractor;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.DependencyWordsFragmentExtractor;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.UncertaintyFeatureExtractor;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Instance;

public class UncertaintyCleartkAnalysisEngine
extends AssertionCleartkAnalysisEngine {
    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.probabilityOfKeepingADefaultExample = 0.25;
        if (this.entityFeatureExtractors == null) {
            this.entityFeatureExtractors = new ArrayList();
        }
        this.entityFeatureExtractors.add(new ContextWordWindowExtractor("org/apache/ctakes/assertion/models/uncertainty.txt"));
        this.entityFeatureExtractors.add(new UncertaintyFeatureExtractor());
        if (this.featConfig == AssertionCleartkAnalysisEngine.FEATURE_CONFIG.STK_FRAGS) {
            this.entityFeatureExtractors.add(new AboveLeftFragmentExtractor("AL_Unc", "org/apache/ctakes/assertion/models/jbi_paper_unc_seed_frags.txt"));
        }
        if (this.featConfig == AssertionCleartkAnalysisEngine.FEATURE_CONFIG.PTK_FRAGS) {
            this.entityFeatureExtractors.add(new DependencyWordsFragmentExtractor("DW_Uncertainty", "org/apache/ctakes/assertion/models/jbi_paper_uncertainty_dw_frags.txt"));
        }
        if (this.featConfig == AssertionCleartkAnalysisEngine.FEATURE_CONFIG.STK) {
            this.entityTreeExtractors.add(new AssertionAboveLeftTreeExtractor());
        }
        if (this.featConfig == AssertionCleartkAnalysisEngine.FEATURE_CONFIG.PTK) {
            this.entityTreeExtractors.add(new AssertionDependencyTreeExtractor());
        }
        this.initializeFeatureSelection();
    }

    @Override
    public void setClassLabel(IdentifiedAnnotation entityOrEventMention, Instance<String> instance) throws AnalysisEngineProcessException {
        if (this.isTraining()) {
            String uncertainty;
            String string = uncertainty = entityOrEventMention.getUncertainty() == 1 ? "uncertain" : "certain";
            if ("certain".equals(uncertainty) && coin.nextDouble() >= this.probabilityOfKeepingADefaultExample) {
                return;
            }
            instance.setOutcome((Object)uncertainty);
        } else {
            String label = (String)this.classifier.classify(instance.getFeatures());
            int uncertainty = 0;
            if (label != null && label.equals("uncertain")) {
                uncertainty = 1;
            } else if (label != null && label.equals("certain")) {
                uncertainty = 0;
            }
            entityOrEventMention.setUncertainty(uncertainty);
        }
    }

    public static FeatureSelection<String> createFeatureSelection(double threshold) {
        return new Chi2FeatureSelection<String>("SelectNeighborFeatures", threshold, false);
    }

    public static URI createFeatureSelectionURI(File outputDirectoryName) {
        return new File(outputDirectoryName, "SelectNeighborFeatures_Chi2_extractor.dat").toURI();
    }

    @Override
    protected void initializeFeatureSelection() throws ResourceInitializationException {
        this.featureSelection = this.featureSelectionThreshold.floatValue() == 0.0f ? null : UncertaintyCleartkAnalysisEngine.createFeatureSelection(this.featureSelectionThreshold.floatValue());
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(UncertaintyCleartkAnalysisEngine.class, (Object[])new Object[]{"FEATURE_CONFIG", AssertionCleartkAnalysisEngine.FEATURE_CONFIG.ALL_SYN, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return UncertaintyCleartkAnalysisEngine.createAnnotatorDescription("/org/apache/ctakes/assertion/models/uncertainty/model.jar");
    }
}

