/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.util;

import java.io.FileNotFoundException;
import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.coreference.type.DemMarkable;
import org.apache.ctakes.coreference.type.Markable;
import org.apache.ctakes.coreference.type.NEMarkable;
import org.apache.ctakes.coreference.type.PronounMarkable;
import org.apache.ctakes.coreference.util.MarkableTreeUtils;
import org.apache.ctakes.coreference.util.PairAttributeCalculator;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.syntax.TopTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.utils.wiki.WikiIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.StringArray;

public class SyntaxAttributeCalculator
extends PairAttributeCalculator {
    private TreebankNode n1;
    private TreebankNode n2;
    private TreebankNode lca;
    HashMap<String, Integer> ngrams = null;
    ConllDependencyNode c1;
    ConllDependencyNode c2;
    ConllDependencyNode depLca = null;
    String path = null;
    String depPath = null;
    WikiIndex wiki = null;
    double sim1 = -1.0;
    double sim2 = -1.0;
    private static int numNEFeats = 0;
    private static int numDemFeats = 0;
    private static int numPronFeats = 0;
    static ArrayList<String> featSet = new ArrayList();
    static ArrayList<String> pronFeatSet = new ArrayList();
    static ArrayList<String> demFeatSet = new ArrayList();
    static int[] selFeats = new int[]{0};
    static int[] pronSelFeats = new int[]{0};

    static ArrayList<String> loadFeatures(int[] featInds, String filename) {
        ArrayList<String> feats = new ArrayList<String>();
        Scanner scanner = null;
        try {
            scanner = new Scanner(FileLocator.locateFile((String)filename));
        }
        catch (FileNotFoundException e) {
            System.err.println("Exception reading filename: " + e.getMessage());
            return feats;
        }
        int ind = 0;
        int lineNum = 0;
        String line = null;
        while (scanner.hasNextLine()) {
            line = scanner.nextLine();
            if (featInds[ind] == ++lineNum) {
                feats.add(line);
                ++ind;
            }
            if (ind < featInds.length) continue;
            break;
        }
        return feats;
    }

    public SyntaxAttributeCalculator(JCas jcas, Markable m1, Markable m2) {
        this(jcas, m1, m2, null);
    }

    public SyntaxAttributeCalculator(JCas jcas, Markable m1, Markable m2, WikiIndex wiki) {
        super(jcas, m1, m2);
        this.n1 = MarkableTreeUtils.markableNode(jcas, m1.getBegin(), m1.getEnd());
        this.lca = this.n2 = MarkableTreeUtils.markableNode(jcas, m2.getBegin(), m2.getEnd());
        while (this.n1 != null && this.lca != null && this.lca.getBegin() > this.n1.getBegin()) {
            this.lca = this.lca.getParent();
        }
        this.ngrams = new HashMap();
        this.calcFullPath();
        this.wiki = wiki;
        if (this.wiki != null) {
            this.initWikiSim();
        }
    }

    public static int getNumNEFeats() {
        return numNEFeats;
    }

    public static int getNumDemFeats() {
        return numDemFeats;
    }

    public static int getNumPronFeats() {
        return numPronFeats;
    }

    private static String calcNPunderPP(TreebankNode n) {
        if (n != null && n.getParent() != null && n.getParent().getNodeType().equals("PP")) {
            return "Y";
        }
        return "N";
    }

    public String calcNPunderPP1() {
        return SyntaxAttributeCalculator.calcNPunderPP(this.n1);
    }

    public String calcNPunderPP2() {
        return SyntaxAttributeCalculator.calcNPunderPP(this.n2);
    }

    private static String calcNPunderS(TreebankNode n) {
        if (n != null && n.getParent() != null && n.getParent().getNodeType().equals("S")) {
            return "Y";
        }
        return "N";
    }

    public String calcNPunderS1() {
        return SyntaxAttributeCalculator.calcNPunderS(this.n1);
    }

    public String calcNPunderS2() {
        return SyntaxAttributeCalculator.calcNPunderS(this.n2);
    }

    private static String calcNPunderVP(TreebankNode n) {
        if (n != null && n.getParent() != null && n.getParent().getNodeType().equals("VP")) {
            return "Y";
        }
        return "N";
    }

    public String calcNPunderVP1() {
        return SyntaxAttributeCalculator.calcNPunderVP(this.n1);
    }

    public String calcNPunderVP2() {
        return SyntaxAttributeCalculator.calcNPunderVP(this.n2);
    }

    public boolean calcNPSubj(TreebankNode n) {
        StringArray tags;
        if (n == null) {
            return false;
        }
        if (n.getNodeType().equals("NP") && (tags = n.getNodeTags()) != null && tags.size() > 0) {
            for (int i = 0; i < tags.size(); ++i) {
                if (!tags.get(i).equals("SBJ")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean calcNPSubj1() {
        return this.calcNPSubj(this.n1);
    }

    public boolean calcNPSubj2() {
        return this.calcNPSubj(this.n2);
    }

    public boolean calcNPSubjBoth() {
        return this.calcNPSubj1() && this.calcNPSubj2();
    }

    public void initWikiSim() {
        if (this.wiki == null) {
            this.sim1 = 0.0;
        } else {
            try {
                this.sim1 = this.wiki.getCosineSimilarity(this.ms1, this.ms2);
                this.sim2 = this.wiki.getCosineSimilarity(this.es1, this.es2);
            }
            catch (Exception e) {
                this.sim1 = 0.0;
                this.sim2 = 0.0;
            }
        }
    }

    public void initEntityWikiSim() {
        if (this.wiki == null) {
            this.sim2 = 0.0;
        } else {
            try {
                this.sim2 = this.wiki.getCosineSimilarity(this.es1, this.es2);
            }
            catch (Exception e) {
                this.sim2 = 0.0;
            }
        }
    }

    public double calcWikiSim() {
        if (this.sim1 < 0.0) {
            this.initWikiSim();
        }
        return this.sim1;
    }

    public double calcEntityWikiSim() {
        if (this.sim2 < 0.0) {
            this.initEntityWikiSim();
        }
        return this.sim2;
    }

    public double calcSimSum() {
        if (this.sim1 < 0.0) {
            this.initWikiSim();
        }
        if (this.sim2 < 0.0) {
            this.initEntityWikiSim();
        }
        return (this.sim1 + this.sim2) / 2.0;
    }

    public int numNgrams(Markable m) throws UnexpectedException {
        if (m instanceof NEMarkable) {
            return featSet.size();
        }
        if (m instanceof PronounMarkable) {
            return pronFeatSet.size();
        }
        if (m instanceof DemMarkable) {
            return demFeatSet.size();
        }
        throw new UnexpectedException("The type passed into numNgrams was not expected!");
    }

    public String calcCatNgrams(Integer i, Markable m) {
        if (m instanceof NEMarkable ? this.ngrams.containsKey(featSet.get(i)) : (m instanceof DemMarkable ? this.ngrams.containsKey(demFeatSet.get(i)) : m instanceof PronounMarkable && this.ngrams.containsKey(pronFeatSet.get(i)))) {
            return "Y";
        }
        return "N";
    }

    public String calcFullPath() {
        if (this.path == null) {
            if (this.n1 == null || this.n2 == null || this.n2.getBegin() <= this.n1.getEnd()) {
                this.path = "";
            } else {
                TreebankNode cur;
                StringBuffer buf = new StringBuffer();
                for (cur = this.n2.getParent(); cur != this.lca && !(cur instanceof TopTreebankNode); cur = cur.getParent()) {
                    buf.append(cur.getNodeType());
                    buf.append("<");
                    if (cur.getParent() == null) break;
                }
                buf.append(this.lca == null ? "TOP" : this.lca.getNodeType());
                StringBuffer bwd = new StringBuffer();
                for (cur = this.n1.getParent(); cur != this.lca && !(cur instanceof TopTreebankNode); cur = cur.getParent()) {
                    bwd.insert(0, cur.getNodeType());
                    bwd.insert(0, ">");
                }
                buf.append(bwd);
                this.path = buf.toString();
                SyntaxAttributeCalculator.initNGrams(this.ngrams, this.path, 3);
                SyntaxAttributeCalculator.initNGrams(this.ngrams, this.path, 4);
                SyntaxAttributeCalculator.initNGrams(this.ngrams, this.path, 5);
            }
        }
        return this.path;
    }

    public double calcPathLength() {
        return (double)this.getPathLength() / 20.0;
    }

    public int getPathLength() {
        String[] nodes = this.path.split("[<>]");
        return nodes.length;
    }

    private static ConllDependencyNode getDepLCA(ConllDependencyNode c1, ConllDependencyNode c2) {
        HashSet<ConllDependencyNode> ancestors = new HashSet<ConllDependencyNode>();
        ConllDependencyNode temp = null;
        for (temp = c2.getHead(); temp != null; temp = temp.getHead()) {
            ancestors.add(temp);
        }
        for (temp = c1.getHead(); temp != null && !ancestors.contains(temp); temp = temp.getHead()) {
        }
        return temp;
    }

    public String calcDepPath() {
        if (this.depPath == null) {
            if (this.c1 == null || this.c2 == null || this.c2.getBegin() <= this.c1.getEnd()) {
                this.depPath = "";
            } else {
                ConllDependencyNode cur;
                StringBuffer buf = new StringBuffer();
                buf.append(this.c2.getDeprel());
                for (cur = this.c2.getHead(); cur != this.depLca && cur != null; cur = cur.getHead()) {
                    String rel = cur.getDeprel();
                    if (rel == null) {
                        cur = null;
                        break;
                    }
                    buf.append("<");
                    buf.append(cur.getDeprel());
                }
                if (cur == null) {
                    buf.append("<TOP");
                }
                StringBuffer bwd = new StringBuffer();
                bwd.append(this.c1.getDeprel());
                bwd.insert(0, ">");
                for (cur = this.c1.getHead(); cur != this.depLca && cur != null; cur = cur.getHead()) {
                    String rel = cur.getDeprel();
                    if (rel == null) {
                        cur = null;
                        break;
                    }
                    bwd.insert(0, cur.getDeprel());
                    bwd.insert(0, ">");
                }
                buf.append(bwd);
                this.depPath = buf.toString();
                SyntaxAttributeCalculator.initNGrams(this.ngrams, this.depPath, 3);
                SyntaxAttributeCalculator.initNGrams(this.ngrams, this.depPath, 4);
                SyntaxAttributeCalculator.initNGrams(this.ngrams, this.depPath, 5);
            }
        }
        return this.depPath;
    }

    private static void initNGrams(HashMap<String, Integer> ngrams, String path, int n) {
        int begin = 0;
        int end = 0;
        int numBracks = 0;
        while (numBracks < n && end < path.length() - 1) {
            if (path.charAt(++end) != '<' && path.charAt(end) != '>') continue;
            ++numBracks;
        }
        if (numBracks < n - 1) {
            return;
        }
        String tg = null;
        tg = end == path.length() - 1 ? path.substring(begin) : path.substring(begin, end);
        int count = 0;
        try {
            count = (ngrams.containsKey(tg) ? ngrams.get(tg) : 0) + 1;
            ngrams.put(tg, count);
        }
        catch (NullPointerException e) {
            System.err.println("Choked on key: " + (tg == null ? "null" : tg));
        }
        while (end < path.length() - 1) {
            while (end < path.length() - 1 && path.charAt(++end) != '<' && path.charAt(end) != '>') {
            }
            while (path.charAt(++begin) != '<' && path.charAt(begin) != '>') {
            }
            ++begin;
            if (end == path.length() - 1) {
                ++end;
            }
            count = (ngrams.containsKey(tg = path.substring(begin, end)) ? ngrams.get(tg) : 0) + 1;
            ngrams.put(tg, count);
        }
    }

    public HashMap<String, Integer> getNGrams() {
        return this.ngrams;
    }
}

