/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.dkpro.core.api.resources;

import de.tudarmstadt.ukp.dkpro.core.api.metadata.AggregateTagset;
import de.tudarmstadt.ukp.dkpro.core.api.metadata.Tagset;
import de.tudarmstadt.ukp.dkpro.core.api.metadata.type.TagDescription;
import de.tudarmstadt.ukp.dkpro.core.api.metadata.type.TagsetDescription;
import de.tudarmstadt.ukp.dkpro.core.api.resources.CasConfigurableStreamProviderBase;
import de.tudarmstadt.ukp.dkpro.core.api.resources.HasTagsets;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.util.FSCollectionFactory;
import org.apache.uima.jcas.JCas;

public class ModelProviderBase<M>
extends CasConfigurableStreamProviderBase<M>
implements HasTagsets {
    private AggregateTagset tagsets = new AggregateTagset();
    private Set<String> skipRecord = new HashSet<String>();

    @Override
    public void configure(CAS aCas) throws AnalysisEngineProcessException {
        super.configure(aCas);
        try {
            this.recordTagsets(aCas);
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    @Override
    protected M produceResource(InputStream aStream) throws Exception {
        return null;
    }

    @Override
    public Tagset getTagset() {
        return this.tagsets;
    }

    protected void addTagset(Tagset aProvider) {
        this.addTagset(aProvider, true);
    }

    protected void addTagset(Tagset aProvider, boolean aRecord) {
        this.tagsets.add(aProvider);
        if (!aRecord) {
            this.skipRecord.addAll(aProvider.getLayers().keySet());
        }
    }

    protected void recordTagsets(CAS aCas) throws CASException {
        JCas jcas = aCas.getJCas();
        if (this instanceof HasTagsets) {
            Tagset provider = this.getTagset();
            for (Map.Entry e : provider.getLayers().entrySet()) {
                if (this.skipRecord.contains(e.getKey())) continue;
                TagsetDescription tsd = new TagsetDescription(jcas, 0, aCas.getDocumentText().length());
                tsd.setLayer((String)e.getKey());
                tsd.setName((String)e.getValue());
                ArrayList<TagDescription> tags = new ArrayList<TagDescription>();
                for (String tag : provider.listTags((String)e.getKey(), (String)e.getValue())) {
                    TagDescription td = new TagDescription(jcas);
                    td.setName(tag);
                    tags.add(td);
                }
                tsd.setTags(FSCollectionFactory.createFSArray((JCas)jcas, tags));
                tsd.addToIndexes();
            }
        }
    }
}

