/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class DependencyFeatureExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        EventMention event = null;
        TimeMention time = null;
        if (arg1 instanceof EventMention) {
            event = (EventMention)arg1;
            time = (TimeMention)arg2;
        } else {
            time = (TimeMention)arg1;
            event = (EventMention)arg2;
        }
        Map dependencyCoveringMap = JCasUtil.indexCovering((JCas)jCas, IdentifiedAnnotation.class, ConllDependencyNode.class);
        Collection eventDNodeList = (Collection)dependencyCoveringMap.get(event);
        Collection timeDNodeList = (Collection)dependencyCoveringMap.get(time);
        if (timeDNodeList != null && !timeDNodeList.isEmpty() && eventDNodeList != null && !eventDNodeList.isEmpty()) {
            for (ConllDependencyNode timeNode : timeDNodeList) {
                ConllDependencyNode headOfTime = timeNode.getHead();
                for (ConllDependencyNode eventNode : eventDNodeList) {
                    if (timeNode.getPostag() == null || eventNode.getPostag() == null) continue;
                    while (headOfTime != null) {
                        if (headOfTime.equals((Object)eventNode)) {
                            Feature indicator = new Feature("DependentTo", (Object)"DependentTo");
                            feats.add(indicator);
                            return feats;
                        }
                        headOfTime = headOfTime.getHead();
                    }
                }
            }
        }
        Feature indicator = new Feature("NotDependent", (Object)"NotDependent");
        feats.add(indicator);
        return feats;
    }
}

