/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature.selection;

import com.google.common.base.Function;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.Set;
import org.apache.ctakes.temporal.ae.feature.selection.FeatureSelection;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.transform.TransformableFeature;

public class OddsRatioFeatureSelection<OUTCOME_T>
extends FeatureSelection<OUTCOME_T> {
    private double oddsRatioThreshold;
    private int numFeatures = 0;
    private String positiveClass = null;
    private OddsRatioScorer<OUTCOME_T> oddsRatioFunction;

    public OddsRatioFeatureSelection(String name) {
        this(name, 0.0);
    }

    public OddsRatioFeatureSelection(String name, double threshold) {
        super(name);
        this.oddsRatioThreshold = threshold;
    }

    public OddsRatioFeatureSelection(String name, double threshold, String posiClas) {
        super(name);
        this.oddsRatioThreshold = threshold;
        this.positiveClass = posiClas;
    }

    @Override
    public boolean apply(Feature feature) {
        return this.selectedFeatureNames.contains(this.getFeatureName(feature));
    }

    public void train(Iterable<Instance<OUTCOME_T>> instances) {
        this.oddsRatioFunction = new OddsRatioScorer(this.positiveClass);
        for (Instance<OUTCOME_T> instance : instances) {
            Object outcome = instance.getOutcome();
            for (Feature feature : instance.getFeatures()) {
                if (!this.isTransformable(feature)) continue;
                for (Feature untransformedFeature : ((TransformableFeature)feature).getFeatures()) {
                    this.oddsRatioFunction.update(this.getFeatureName(untransformedFeature), outcome, 1);
                }
            }
        }
        Set featureNames = this.oddsRatioFunction.featValueClassCount.rowKeySet();
        Ordering ordering = Ordering.natural().onResultOf(this.oddsRatioFunction).reverse();
        int totalFeatures = featureNames.size();
        this.numFeatures = (int)Math.round((double)totalFeatures * this.oddsRatioThreshold);
        this.selectedFeatureNames = Sets.newLinkedHashSet((Iterable)ordering.immutableSortedCopy((Iterable)featureNames).subList(0, this.numFeatures));
        this.isTrained = true;
    }

    public void save(URI uri) throws IOException {
        if (!this.isTrained) {
            throw new IllegalStateException("Cannot save before training");
        }
        File out = new File(uri);
        BufferedWriter writer = new BufferedWriter(new FileWriter(out));
        for (String feature : this.selectedFeatureNames) {
            writer.append(String.format("%s\t%f\n", feature, this.oddsRatioFunction.score(feature)));
        }
        writer.close();
    }

    public void load(URI uri) throws IOException {
        this.selectedFeatureNames = Sets.newLinkedHashSet();
        File in = new File(uri);
        BufferedReader reader = new BufferedReader(new FileReader(in));
        String line = null;
        for (int n = 0; (line = reader.readLine()) != null && n < this.numFeatures; ++n) {
            String[] featureValuePair = line.split("\t");
            this.selectedFeatureNames.add(featureValuePair[0]);
        }
        reader.close();
        this.isTrained = true;
    }

    private static class OddsRatioScorer<OUTCOME_T>
    implements Function<String, Double> {
        protected Multiset<OUTCOME_T> classCounts = HashMultiset.create();
        protected Table<String, OUTCOME_T, Integer> featValueClassCount = HashBasedTable.create();
        private String positiveClass = null;

        public OddsRatioScorer(String posiClas) {
            this.positiveClass = posiClas;
        }

        public void update(String featureName, OUTCOME_T outcome, int occurrences) {
            Integer count = (Integer)this.featValueClassCount.get((Object)featureName, outcome);
            if (count == null) {
                count = 0;
            }
            this.featValueClassCount.put((Object)featureName, outcome, (Object)(count + occurrences));
            this.classCounts.add(outcome, occurrences);
        }

        public Double apply(String featureName) {
            return this.score(featureName);
        }

        public double score(String featureName) {
            int n11 = 1;
            int n10 = 1;
            int n01 = 1;
            int n00 = 1;
            for (Object clas : this.classCounts.elementSet()) {
                int numPositiveFeature = this.featValueClassCount.contains((Object)featureName, clas) ? (Integer)this.featValueClassCount.get((Object)featureName, clas) : 0;
                int numNegativeFeature = this.classCounts.count(clas) - numPositiveFeature;
                if (clas.toString().equals("B") || clas.toString().equals("I") || clas.toString().equals(this.positiveClass)) {
                    n11 += numPositiveFeature;
                    n01 += numNegativeFeature;
                    continue;
                }
                if (this.positiveClass == null && clas.toString().equals("O")) {
                    n10 += numPositiveFeature;
                    n00 += numNegativeFeature;
                    continue;
                }
                System.err.println("Please define postive class label for odds ratio calculation.");
                System.exit(0);
            }
            double oddsratio = Math.log(n11) + Math.log(n00) - Math.log(n10) - Math.log(n01);
            return oddsratio;
        }
    }
}

