/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.nn.ae;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.temporal.ae.TemporalRelationExtractorAnnotator;
import org.apache.ctakes.temporal.nn.ae.EventTimeTokenBasedAnnotator;
import org.apache.ctakes.temporal.nn.data.ArgContextProvider;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.util.ViewUriUtil;

@PipeBitInfo(name="E-E Token TLinker", description="Creates Event - Event TLinks from Token type.", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.EVENT}, products={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public class EventEventTokenBasedAnnotator
extends CleartkAnnotator<String> {
    public static final String NO_RELATION_CATEGORY = "none";
    private static TimeMention coveringTimex;
    public static Map<String, Integer> timex_idx;
    public static EventTimeTokenBasedAnnotator.OutputMode timexMode;
    private BufferedReader reader;
    private static FileWriter fstream;
    private static BufferedWriter out;

    public EventEventTokenBasedAnnotator() {
        timexMode = EventTimeTokenBasedAnnotator.OutputMode.TimeclassPosSeq;
        if (timexMode == EventTimeTokenBasedAnnotator.OutputMode.IndexTags) {
            timex_idx = new HashMap<String, Integer>();
        }
    }

    public Map<String, Integer> TimexIdxReader(InputStream in) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(in));
        HashMap<String, Integer> timex_index = new HashMap<String, Integer>();
        String line = null;
        while ((line = this.reader.readLine()) != null) {
            line = line.trim();
            int sep = line.lastIndexOf("|");
            String timex = line.substring(0, sep);
            Integer idx = Integer.parseInt(line.substring(sep + 1));
            timex_index.put(timex, idx);
        }
        this.reader.close();
        return timex_index;
    }

    public static void TimexIdxWriter() throws IOException {
        fstream = new FileWriter("target/eval/thyme/train_and_test/event-event/timex_idx.txt");
        out = new BufferedWriter(fstream);
        for (Map.Entry<String, Integer> pairs : timex_idx.entrySet()) {
            out.write(pairs.getKey() + "|" + pairs.getValue() + "\n");
        }
        out.close();
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        if (timexMode == EventTimeTokenBasedAnnotator.OutputMode.IndexTags && !this.isTraining()) {
            String timexIdxMapFile = "target/eval/thyme/train_and_test/event-event/timex_idx.txt";
            try {
                timex_idx = this.TimexIdxReader(FileLocator.getAsStream((String)"target/eval/thyme/train_and_test/event-event/timex_idx.txt"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<List<Annotation>, BinaryTextRelation> relationLookup = new HashMap<List<Annotation>, BinaryTextRelation>();
        if (this.isTraining()) {
            relationLookup = new HashMap();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)jCas, BinaryTextRelation.class)) {
                Annotation arg2;
                Annotation arg1 = relation.getArg1().getArgument();
                List<Annotation> key = Arrays.asList(arg1, arg2 = relation.getArg2().getArgument());
                if (relationLookup.containsKey(key)) {
                    String reln = ((BinaryTextRelation)relationLookup.get(key)).getCategory();
                    System.err.println("Error in: " + ViewUriUtil.getURI((JCas)jCas).toString());
                    System.err.println("Error! This attempted relation " + relation.getCategory() + " already has a relation " + reln + " at this span: " + arg1.getCoveredText() + " -- " + arg2.getCoveredText());
                    continue;
                }
                relationLookup.put(key, relation);
            }
        }
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            List<TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair> candidatePairs = EventEventTokenBasedAnnotator.getCandidateRelationArgumentPairs(jCas, sentence);
            for (TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair pair : candidatePairs) {
                String[] tokens;
                String context;
                IdentifiedAnnotation arg1 = pair.getArg1();
                IdentifiedAnnotation arg2 = pair.getArg2();
                if (arg2.getBegin() < arg1.getBegin()) {
                    System.out.println("\n-------------- THIS NEVER NAPPENS ------------\n");
                    context = timexMode == EventTimeTokenBasedAnnotator.OutputMode.TokenSeq ? ArgContextProvider.getTokenContext(jCas, sentence, (Annotation)arg2, "e2", (Annotation)arg1, "e1", 2) : EventEventTokenBasedAnnotator.getTokenTimexContext(jCas, sentence, arg2, "e2", arg1, "e1", 2);
                } else {
                    context = timexMode == EventTimeTokenBasedAnnotator.OutputMode.TokenSeq ? ArgContextProvider.getTokenContext(jCas, sentence, (Annotation)arg1, "e1", (Annotation)arg2, "e2", 2) : EventEventTokenBasedAnnotator.getTokenTimexContext(jCas, sentence, arg1, "e1", arg2, "e2", 2);
                }
                ArrayList<Feature> feats = new ArrayList<Feature>();
                for (String token : tokens = context.split(" ")) {
                    feats.add(new Feature((Object)token.toLowerCase()));
                }
                if (this.isTraining()) {
                    String category = this.getRelationCategory(relationLookup, arg1, arg2);
                    category = category == null ? NO_RELATION_CATEGORY : category.toLowerCase();
                    this.dataWriter.write(new Instance((Object)category, feats));
                    continue;
                }
                String predictedCategory = (String)this.classifier.classify(feats);
                if (predictedCategory == null || predictedCategory.equals(NO_RELATION_CATEGORY)) continue;
                if (predictedCategory.endsWith("-1")) {
                    predictedCategory = predictedCategory.substring(0, predictedCategory.length() - 2);
                    IdentifiedAnnotation temp = arg1;
                    arg1 = arg2;
                    arg2 = temp;
                }
                this.createRelation(jCas, arg1, arg2, predictedCategory.toUpperCase(), 0.0);
            }
        }
        if (timexMode == EventTimeTokenBasedAnnotator.OutputMode.IndexTags && !this.isTraining()) {
            try {
                EventEventTokenBasedAnnotator.TimexIdxWriter();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getTokenTimexContext(JCas jCas, Sentence sentence, IdentifiedAnnotation arg1, String leftType, IdentifiedAnnotation arg2, String rightType, int contextSize) {
        String timeTag;
        List<String> tokens = new ArrayList<String>();
        List preTimex = JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (int)sentence.getBegin(), (int)arg1.getBegin());
        List betweenTimex = JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (int)arg1.getEnd(), (int)arg2.getBegin());
        List afterTimex = JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (int)arg2.getEnd(), (int)sentence.getEnd());
        tokens = EventEventTokenBasedAnnotator.addTimex2TokenSequence(jCas, tokens, JCasUtil.selectPreceding((JCas)jCas, BaseToken.class, (AnnotationFS)arg1, (int)contextSize), preTimex, sentence);
        tokens.add("<" + leftType + ">");
        if (arg1 instanceof TimeMention) {
            timeTag = EventEventTokenBasedAnnotator.generateTimeTag(jCas, (TimeMention)arg1);
            tokens.add(timeTag);
        } else {
            tokens.add(arg1.getCoveredText());
        }
        tokens.add("</" + leftType + ">");
        tokens = EventEventTokenBasedAnnotator.addTimex2TokenSequence(jCas, tokens, JCasUtil.selectBetween((JCas)jCas, BaseToken.class, (AnnotationFS)arg1, (AnnotationFS)arg2), betweenTimex, sentence);
        tokens.add("<" + rightType + ">");
        if (arg2 instanceof TimeMention) {
            timeTag = EventEventTokenBasedAnnotator.generateTimeTag(jCas, (TimeMention)arg2);
            tokens.add(timeTag);
        } else {
            tokens.add(arg2.getCoveredText());
        }
        tokens.add("</" + rightType + ">");
        tokens = EventEventTokenBasedAnnotator.addTimex2TokenSequence(jCas, tokens, JCasUtil.selectFollowing((JCas)jCas, BaseToken.class, (AnnotationFS)arg2, (int)contextSize), afterTimex, sentence);
        return String.join((CharSequence)" ", tokens).replaceAll("[\r\n]", " ");
    }

    private static String generateTimeTag(JCas jCas, TimeMention timex) {
        String timeTag = "<timex";
        if (timexMode == EventTimeTokenBasedAnnotator.OutputMode.IndexTags) {
            timeTag = timeTag + "_";
            int idx = 0;
            String timeWord = timex.getCoveredText().toLowerCase().replaceAll("[\r\n]", " ");
            if (timex_idx.containsKey(timeWord)) {
                idx = timex_idx.get(timeWord);
            } else {
                idx = timex_idx.size();
                timex_idx.put(timeWord, idx);
            }
            timeTag = timeTag + idx + ">";
        } else if (timexMode == EventTimeTokenBasedAnnotator.OutputMode.Timeclass) {
            timeTag = "<timex_" + timex.getTimeClass() + ">";
        } else if (timexMode == EventTimeTokenBasedAnnotator.OutputMode.TimeclassPosSeq) {
            timeTag = "<timex_" + timex.getTimeClass();
            for (BaseToken token : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)timex)) {
                timeTag = timeTag + "_" + token.getPartOfSpeech();
            }
            timeTag = timeTag + ">";
        } else if (timexMode == EventTimeTokenBasedAnnotator.OutputMode.PosSeq) {
            timeTag = "<timex";
            for (BaseToken token : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)timex)) {
                timeTag = timeTag + "_" + token.getPartOfSpeech();
            }
            timeTag = timeTag + ">";
        } else if (timexMode == EventTimeTokenBasedAnnotator.OutputMode.SingleTag) {
            timeTag = timeTag + ">";
        } else if (timexMode == EventTimeTokenBasedAnnotator.OutputMode.TokenTimeclass) {
            timeTag = timex.getCoveredText() + " <timex_" + timex.getTimeClass() + ">";
        } else if (timexMode == EventTimeTokenBasedAnnotator.OutputMode.TokenTimeclassPosSeq) {
            timeTag = timex.getCoveredText() + " <timex_" + timex.getTimeClass();
            for (BaseToken token : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)timex)) {
                timeTag = timeTag + "_" + token.getPartOfSpeech();
            }
            timeTag = timeTag + ">";
        } else if (timexMode == EventTimeTokenBasedAnnotator.OutputMode.NoTag) {
            timeTag = "";
        }
        return timeTag;
    }

    private static List<String> addTimex2TokenSequence(JCas jCas, List<String> tokens, List<BaseToken> tokenSequences, List<TimeMention> listOfTimex, Sentence sent) {
        coveringTimex = null;
        for (BaseToken baseToken : tokenSequences) {
            if (baseToken.getEnd() > sent.getEnd() || sent.getBegin() > baseToken.getBegin()) continue;
            TimeMention currentTimex = EventEventTokenBasedAnnotator.findCoveringTimex(baseToken, listOfTimex);
            if (currentTimex == null) {
                if (coveringTimex != null) {
                    coveringTimex = null;
                }
                tokens.add(baseToken.getCoveredText());
                continue;
            }
            if (currentTimex == coveringTimex) continue;
            String timeTag = EventEventTokenBasedAnnotator.generateTimeTag(jCas, currentTimex);
            tokens.add(timeTag);
            coveringTimex = currentTimex;
        }
        return tokens;
    }

    private static TimeMention findCoveringTimex(BaseToken baseToken, List<TimeMention> timexs) {
        for (TimeMention timex : timexs) {
            if (timex.getBegin() > baseToken.getBegin() || timex.getEnd() < baseToken.getEnd()) continue;
            return timex;
        }
        return null;
    }

    protected String getRelationCategory(Map<List<Annotation>, BinaryTextRelation> relationLookup, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        BinaryTextRelation relation = relationLookup.get(Arrays.asList(arg1, arg2));
        String category = null;
        if (relation != null) {
            category = arg2.getBegin() < arg1.getBegin() ? relation.getCategory() + "-1" : relation.getCategory();
        } else {
            relation = relationLookup.get(Arrays.asList(arg2, arg1));
            if (relation != null) {
                category = arg2.getBegin() < arg1.getBegin() ? relation.getCategory() : relation.getCategory() + "-1";
            }
        }
        return category;
    }

    protected String getRelationCategory2(Map<List<Annotation>, BinaryTextRelation> relationLookup, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        BinaryTextRelation arg1ContainsArg2 = relationLookup.get(Arrays.asList(arg1, arg2));
        BinaryTextRelation arg2ContainsArg1 = relationLookup.get(Arrays.asList(arg2, arg1));
        if (arg1ContainsArg2 != null) {
            if (arg1.getBegin() < arg2.getBegin()) {
                return arg1ContainsArg2.getCategory();
            }
            return arg1ContainsArg2.getCategory() + "-1";
        }
        if (arg2ContainsArg1 != null) {
            if (arg1.getBegin() < arg2.getBegin()) {
                return arg2ContainsArg1.getCategory() + "-1";
            }
            return arg2ContainsArg1.getCategory();
        }
        return null;
    }

    protected void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String predictedCategory, double confidence) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Arg1");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Arg2");
        relArg2.addToIndexes();
        TemporalTextRelation relation = new TemporalTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        relation.setConfidence(confidence);
        relation.addToIndexes();
    }

    private static List<TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas jCas, Sentence sentence) {
        ArrayList pairs = Lists.newArrayList();
        ArrayList events = new ArrayList(JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)sentence));
        ArrayList realEvents = Lists.newArrayList();
        for (EventMention event : events) {
            if (!event.getClass().equals(EventMention.class)) continue;
            realEvents.add(event);
        }
        events = realEvents;
        int eventNum = events.size();
        for (int i = 0; i < eventNum - 1; ++i) {
            for (int j = i + 1; j < eventNum; ++j) {
                EventMention eventA = (EventMention)events.get(i);
                EventMention eventB = (EventMention)events.get(j);
                pairs.add(new TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)eventA, (IdentifiedAnnotation)eventB));
            }
        }
        return pairs;
    }
}

