/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.TransducerEvaluator;
import cc.mallet.fst.TransducerTrainer;
import cc.mallet.types.InstanceList;
import cc.mallet.util.MalletLogger;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;

public class CRFWriter
extends TransducerEvaluator {
    private static Logger logger = MalletLogger.getLogger(CRFWriter.class.getName());
    String filenamePrefix;

    public CRFWriter(String filenamePrefix) {
        super(new InstanceList[0], new String[0]);
        this.filenamePrefix = filenamePrefix;
    }

    @Override
    protected void preamble(TransducerTrainer tt) {
        int iteration = tt.getIteration();
        String filename = this.filenamePrefix + "." + iteration + ".bin";
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(filename));
            oos.writeObject(tt.getTransducer());
            logger.info("Trained model saved: " + filename + ", iter: " + iteration);
        }
        catch (FileNotFoundException fnfe) {
            logger.warning("Could not save model: " + filename + ", iter: " + iteration);
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            logger.warning("Could not save model: " + filename + ", iter: " + iteration);
            ioe.printStackTrace();
        }
    }

    @Override
    public void evaluateInstanceList(TransducerTrainer transducer, InstanceList instances, String description) {
    }
}

