/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae.features;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.DistanceExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.NamingExtractor1;

public class NamedEntityFeaturesExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    private FeatureExtractor1 namedEntityType = new FeatureExtractor1(){

        public List<Feature> extract(JCas jCas, Annotation ann) throws CleartkExtractorException {
            IdentifiedAnnotation idAnn = (IdentifiedAnnotation)ann;
            return Arrays.asList(new Feature("TypeID", (Object)String.valueOf(idAnn.getTypeID())));
        }
    };
    private FeatureExtractor1 mention1FeaturesExtractor = new NamingExtractor1("mention1", this.namedEntityType);
    private FeatureExtractor1 mention2FeaturesExtractor = new NamingExtractor1("mention2", this.namedEntityType);
    private DistanceExtractor nEntityMentionsBetween = new DistanceExtractor(null, EntityMention.class);

    @Override
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.addAll(this.mention1FeaturesExtractor.extract(jCas, (Annotation)arg1));
        features.addAll(this.mention2FeaturesExtractor.extract(jCas, (Annotation)arg2));
        features.addAll(this.nEntityMentionsBetween.extract(jCas, (Annotation)arg1, (Annotation)arg2));
        int type1 = arg1.getTypeID();
        int type2 = arg2.getTypeID();
        features.add(new Feature("type1type2", (Object)String.format("%s_%s", type1, type2)));
        boolean begins1After2 = arg1.getBegin() >= arg2.getBegin();
        boolean ends1Before2 = arg1.getEnd() <= arg2.getEnd();
        features.add(new Feature("mention1InMention2", (Object)(begins1After2 && ends1Before2 ? 1 : 0)));
        boolean begins2After1 = arg2.getBegin() >= arg1.getBegin();
        boolean ends2Before1 = arg2.getEnd() <= arg1.getEnd();
        features.add(new Feature("mention2InMention1", (Object)(begins2After1 && ends2Before1 ? 1 : 0)));
        return features;
    }
}

