/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.liblinear.encoder;

import com.google.common.collect.Maps;
import de.bwaldvogel.liblinear.FeatureNode;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.cleartk.ml.Feature;
import org.cleartk.ml.encoder.CleartkEncoderException;
import org.cleartk.ml.encoder.features.FeaturesEncoder;

public class FeatureNodeArrayEncoder
implements FeaturesEncoder<FeatureNode[]> {
    private static final long serialVersionUID = 1L;
    private static final String BIAS_NAME = FeatureNodeArrayEncoder.class.getName() + ".BIAS";
    private Map<String, Integer> stringToInt = Maps.newHashMap();
    private int biasIndex = 1;
    private boolean isFinalized = false;

    public FeatureNodeArrayEncoder() {
        this.stringToInt.put(BIAS_NAME, this.biasIndex);
    }

    public FeatureNode[] encodeAll(Iterable<Feature> features) throws CleartkEncoderException {
        TreeMap featureNodes = Maps.newTreeMap();
        featureNodes.put(this.biasIndex, new FeatureNode(this.biasIndex, 1.0));
        for (Feature feature : features) {
            double value;
            String name;
            if (feature.getValue() instanceof Number) {
                name = feature.getName();
                value = ((Number)feature.getValue()).doubleValue();
            } else {
                name = Feature.createName((String[])new String[]{feature.getName(), feature.getValue().toString()});
                value = 1.0;
            }
            if (!this.stringToInt.containsKey(name)) {
                if (this.isFinalized) continue;
                this.stringToInt.put(name, this.stringToInt.size() + 1);
            }
            int index = this.stringToInt.get(name);
            featureNodes.put(index, new FeatureNode(index, value));
        }
        FeatureNode[] featureNodeArray = new FeatureNode[featureNodes.size()];
        int i = 0;
        for (Integer index : featureNodes.keySet()) {
            featureNodeArray[i] = (FeatureNode)featureNodes.get(index);
            ++i;
        }
        return featureNodeArray;
    }

    public void finalizeFeatureSet(File outputDirectory) throws IOException {
        this.isFinalized = true;
    }
}

