/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.jar;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarInputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.fit.component.initialize.ConfigurationParameterInitializer;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.initializable.Initializable;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.jar.JarClassifierBuilder;

public abstract class GenericJarClassifierFactory<CLASSIFIER_TYPE>
implements Initializable {
    public static final String PARAM_CLASSIFIER_JAR_PATH = "classifierJarPath";
    @ConfigurationParameter(name="classifierJarPath", mandatory=true, description="provides the path to the jar file that should be used to instantiate the classifier.")
    private String classifierJarPath;

    public void setClassifierJarPath(String classifierJarPath) {
        this.classifierJarPath = classifierJarPath;
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        ConfigurationParameterInitializer.initialize((Object)this, (UimaContext)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLASSIFIER_TYPE createClassifier() throws IOException {
        InputStream stream = this.getClass().getResourceAsStream(this.classifierJarPath);
        if (stream == null) {
            try {
                stream = new URL(this.classifierJarPath).openStream();
            }
            catch (MalformedURLException e) {
                stream = new FileInputStream(this.classifierJarPath);
            }
        }
        stream = new BufferedInputStream(stream);
        JarInputStream modelStream = new JarInputStream(stream);
        JarClassifierBuilder<?> builder = JarClassifierBuilder.fromManifest(modelStream.getManifest());
        try {
            CLASSIFIER_TYPE CLASSIFIER_TYPE = this.getClassifierClass().cast(builder.loadClassifier(modelStream));
            return CLASSIFIER_TYPE;
        }
        finally {
            stream.close();
        }
    }

    protected abstract Class<CLASSIFIER_TYPE> getClassifierClass();
}

