/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel;

import com.google.common.collect.BiMap;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.InstanceData;
import org.apache.ctakes.ytex.kernel.KernelUtil;
import org.apache.ctakes.ytex.kernel.SparseData;
import org.apache.ctakes.ytex.kernel.SparseDataFormatter;

public abstract class BaseSparseDataFormatter
implements SparseDataFormatter {
    protected KernelUtil kernelUtil;
    protected String outdir = null;
    protected Map<String, Integer> numericAttributeMap = new HashMap<String, Integer>();
    protected Map<String, Map<String, Integer>> nominalAttributeMap = new HashMap<String, Map<String, Integer>>();
    protected Map<String, BiMap<String, Integer>> labelToClassIndexMap = new HashMap<String, BiMap<String, Integer>>();
    protected int maxAttributeIndex = 0;
    protected Properties exportProperties;

    public BaseSparseDataFormatter(KernelUtil kernelUtil) {
        this.kernelUtil = kernelUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportAttributeNames(SparseData sparseData, String label, Integer run, Integer fold) throws IOException {
        this.nominalAttributeMap.clear();
        this.numericAttributeMap.clear();
        this.maxAttributeIndex = 0;
        String filename = FileUtil.getScopedFileName(this.outdir, label, run, fold, "attributes.txt");
        try (BufferedWriter w = null;){
            w = new BufferedWriter(new FileWriter(filename));
            this.exportAttributeNames(w, sparseData);
        }
    }

    protected int exportAttributeNames(BufferedWriter w, SparseData sparseData) throws IOException {
        for (String string : sparseData.getNumericWords()) {
            this.addNumericAttribute(w, string);
        }
        for (Map.Entry entry : sparseData.getNominalWordValueMap().entrySet()) {
            HashMap<String, Integer> attrValueIndexMap = new HashMap<String, Integer>(((SortedSet)entry.getValue()).size());
            for (String attrValue : (SortedSet)entry.getValue()) {
                w.write((String)entry.getKey());
                if (((SortedSet)entry.getValue()).size() > 1) {
                    w.write("\t");
                    w.write(attrValue);
                }
                w.write("\n");
                attrValueIndexMap.put(attrValue, ++this.maxAttributeIndex);
            }
            this.nominalAttributeMap.put((String)entry.getKey(), (Map<String, Integer>)attrValueIndexMap);
        }
        return this.maxAttributeIndex;
    }

    protected void addNumericAttribute(BufferedWriter w, String attributeName) throws IOException {
        w.write(attributeName);
        w.write("\n");
        this.numericAttributeMap.put(attributeName, ++this.maxAttributeIndex);
    }

    protected SortedMap<Integer, Double> getSparseLineValues(SparseData bagOfWordsData, Map<String, Integer> numericAttributeMap, Map<String, Map<String, Integer>> nominalAttributeMap, long instanceId) {
        TreeMap<Integer, Double> instanceValues = new TreeMap<Integer, Double>();
        if (bagOfWordsData.getInstanceNumericWords().containsKey(instanceId)) {
            for (Map.Entry<String, Double> entry : bagOfWordsData.getInstanceNumericWords().get(instanceId).entrySet()) {
                instanceValues.put(numericAttributeMap.get(entry.getKey()), entry.getValue());
            }
        }
        if (bagOfWordsData.getInstanceNominalWords().containsKey(instanceId)) {
            for (Map.Entry<String, Object> entry : bagOfWordsData.getInstanceNominalWords().get(instanceId).entrySet()) {
                instanceValues.put(nominalAttributeMap.get(entry.getKey()).get(entry.getValue()), 1.0);
            }
        }
        return instanceValues;
    }

    protected void exportSparseRow(SparseData bagOfWordsData, long instanceId, BufferedWriter wData, int row) throws IOException {
        SortedMap<Integer, Double> instanceValues = this.getSparseLineValues(bagOfWordsData, this.numericAttributeMap, this.nominalAttributeMap, instanceId);
        for (Map.Entry<Integer, Double> instanceValue : instanceValues.entrySet()) {
            wData.write(Integer.toString(row));
            wData.write("\t");
            wData.write(Integer.toString(instanceValue.getKey()));
            wData.write("\t");
            if (instanceValue.getKey() == 1) {
                wData.write(Long.toString(instanceValue.getValue().longValue()));
            } else {
                wData.write(Double.toString(instanceValue.getValue()));
            }
            wData.write("\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportSparseMatrix(String filename, SparseData sparseData) throws IOException {
        try (BufferedWriter wData = null;){
            wData = new BufferedWriter(new FileWriter(filename));
            int row = 1;
            Iterator iterator = sparseData.getInstanceIds().iterator();
            while (iterator.hasNext()) {
                long instanceId = (Long)iterator.next();
                this.exportSparseRow(sparseData, instanceId, wData, row);
                ++row;
            }
        }
    }

    @Override
    public void initializeExport(InstanceData instanceLabel, Properties properties, SparseData sparseData) throws IOException {
        this.exportProperties = properties;
        this.outdir = properties.getProperty("outdir");
        FileUtil.createOutdir(this.outdir);
        this.kernelUtil.fillLabelToClassToIndexMap(instanceLabel.getLabelToClassMap(), this.labelToClassIndexMap);
    }

    protected void updateLabelClassMapTransductive() {
        for (Map map : this.labelToClassIndexMap.values()) {
            map.put("0", 0);
        }
    }
}

