/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.propbank;

import com.googlecode.clearnlp.constituent.CTLibEn;
import com.googlecode.clearnlp.constituent.CTTree;
import com.googlecode.clearnlp.propbank.PBArg;
import com.googlecode.clearnlp.propbank.PBLoc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PBInstance
implements Comparable<PBInstance> {
    public String treePath;
    public int treeId;
    public int predId;
    public String annotator;
    public String type;
    public String roleset;
    public String aspects;
    protected List<PBArg> l_args;
    protected CTTree tree = null;

    public PBInstance() {
        this.l_args = new ArrayList<PBArg>();
    }

    public PBInstance(String str) {
        String[] tmp = str.split(" ");
        if (tmp.length < 7) {
            System.err.println("Error: missing fields - " + str);
            System.exit(1);
        }
        try {
            this.treePath = tmp[0];
            this.treeId = Integer.parseInt(tmp[1]);
            this.predId = Integer.parseInt(tmp[2]);
            this.annotator = tmp[3];
            this.type = tmp[4];
            this.roleset = tmp[5];
            this.aspects = tmp[6];
        }
        catch (NumberFormatException e) {
            System.err.println("Error: illegal format - " + str);
            System.exit(1);
        }
        int size = tmp.length;
        this.l_args = new ArrayList<PBArg>();
        for (int i = 7; i < size; ++i) {
            this.addArg(new PBArg(tmp[i]));
        }
    }

    public PBArg getArg(int index) {
        return 0 <= index && index < this.l_args.size() ? this.l_args.get(index) : null;
    }

    public PBArg getFirstArg(String label) {
        for (PBArg arg : this.l_args) {
            if (!arg.isLabel(label)) continue;
            return arg;
        }
        return null;
    }

    public List<PBArg> getArgs() {
        return this.l_args;
    }

    public void addArg(PBArg arg) {
        this.l_args.add(arg);
    }

    public void addArgs(Collection<PBArg> args) {
        this.l_args.addAll(args);
    }

    public void removeArgs(Collection<PBArg> args) {
        this.l_args.removeAll(args);
    }

    public void removeArgs(String label) {
        ArrayList<PBArg> remove = new ArrayList<PBArg>();
        for (PBArg arg : this.l_args) {
            if (!arg.isLabel(label)) continue;
            remove.add(arg);
        }
        this.l_args.removeAll(remove);
    }

    public void sortArgs() {
        for (PBArg arg : this.l_args) {
            arg.sortLocs();
        }
        Collections.sort(this.l_args);
    }

    public int getArgSize() {
        return this.l_args.size();
    }

    public CTTree getTree() {
        return this.tree;
    }

    public String getKey() {
        return this.getKey(this.predId);
    }

    public String getKey(int predId) {
        StringBuilder build = new StringBuilder();
        build.append(this.treePath);
        build.append("_");
        build.append(this.treeId);
        build.append("_");
        build.append(predId);
        return build.toString();
    }

    public void setTree(CTTree tree) {
        this.tree = tree;
    }

    public boolean isLVNounPredicate(CTTree cTree) {
        if (!this.isNounPredicate()) {
            return false;
        }
        PBArg rel = this.getFirstArg("rel");
        if (rel == null) {
            return false;
        }
        for (PBLoc loc : rel.l_locs) {
            if (!CTLibEn.isVerb(cTree.getNode(loc))) continue;
            return true;
        }
        return false;
    }

    public boolean isVerbPredicate() {
        return this.type.endsWith("-v");
    }

    public boolean isNounPredicate() {
        return this.type.endsWith("-n");
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        build.append(this.treePath);
        build.append(" ");
        build.append(this.treeId);
        build.append(" ");
        build.append(this.predId);
        build.append(" ");
        build.append(this.annotator);
        build.append(" ");
        build.append(this.type);
        build.append(" ");
        build.append(this.roleset);
        build.append(" ");
        build.append(this.aspects);
        for (PBArg arg : this.l_args) {
            build.append(" ");
            build.append(arg.toString());
        }
        return build.toString();
    }

    @Override
    public int compareTo(PBInstance instance) {
        int cmp = this.treePath.compareTo(instance.treePath);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.treeId - instance.treeId;
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.predId - instance.predId;
        if (cmp != 0) {
            return cmp;
        }
        return this.roleset.compareTo(instance.roleset);
    }
}

