/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi;

import edu.mit.jwi.ICachingDictionary;
import edu.mit.jwi.IDictionary;
import edu.mit.jwi.data.IHasLifecycle;
import edu.mit.jwi.item.ExceptionEntryID;
import edu.mit.jwi.item.IExceptionEntry;
import edu.mit.jwi.item.IExceptionEntryID;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IIndexWordID;
import edu.mit.jwi.item.IItem;
import edu.mit.jwi.item.IItemID;
import edu.mit.jwi.item.ISenseEntry;
import edu.mit.jwi.item.ISenseKey;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IVersion;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.IndexWordID;
import edu.mit.jwi.item.POS;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CachingDictionary
implements ICachingDictionary {
    private final IDictionary backing;
    private final ICachingDictionary.IItemCache cache;

    public CachingDictionary(IDictionary backing) {
        if (backing == null) {
            throw new NullPointerException();
        }
        this.cache = this.createCache();
        this.backing = backing;
    }

    public IDictionary getBackingDictionary() {
        return this.backing;
    }

    protected ICachingDictionary.IItemCache createCache() {
        return new ItemCache();
    }

    protected void checkOpen() {
        if (this.isOpen()) {
            if (!this.getCache().isOpen()) {
                try {
                    this.getCache().open();
                }
                catch (IOException e) {
                    throw new IHasLifecycle.ObjectClosedException(e);
                }
            }
        } else {
            if (this.getCache().isOpen()) {
                this.getCache().close();
            }
            throw new IHasLifecycle.ObjectClosedException();
        }
    }

    @Override
    public ICachingDictionary.IItemCache getCache() {
        return this.cache;
    }

    @Override
    public boolean open() throws IOException {
        if (this.isOpen()) {
            return true;
        }
        this.cache.open();
        return this.backing.open();
    }

    @Override
    public boolean isOpen() {
        return this.backing.isOpen();
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.getCache().close();
        this.backing.close();
    }

    @Override
    public IVersion getVersion() {
        return this.backing.getVersion();
    }

    @Override
    public IIndexWord getIndexWord(String lemma, POS pos) {
        this.checkOpen();
        IndexWordID id = new IndexWordID(lemma, pos);
        IIndexWord item = (IIndexWord)this.getCache().retrieveItem(id);
        if (item == null && (item = this.backing.getIndexWord(id)) != null) {
            this.getCache().cacheItem(item);
        }
        return item;
    }

    @Override
    public IIndexWord getIndexWord(IIndexWordID id) {
        this.checkOpen();
        IIndexWord item = (IIndexWord)this.getCache().retrieveItem(id);
        if (item == null && (item = this.backing.getIndexWord(id)) != null) {
            this.getCache().cacheItem(item);
        }
        return item;
    }

    @Override
    public Iterator<IIndexWord> getIndexWordIterator(POS pos) {
        return this.backing.getIndexWordIterator(pos);
    }

    @Override
    public IWord getWord(IWordID id) {
        this.checkOpen();
        IWord item = (IWord)this.getCache().retrieveItem(id);
        if (item == null && (item = this.backing.getWord(id)) != null) {
            this.cacheSynset(item.getSynset());
        }
        return item;
    }

    @Override
    public IWord getWord(ISenseKey key) {
        this.checkOpen();
        IWord item = this.getCache().retrieveWord(key);
        if (item == null && (item = this.backing.getWord(key)) != null) {
            this.cacheSynset(item.getSynset());
        }
        return item;
    }

    @Override
    public ISynset getSynset(ISynsetID id) {
        this.checkOpen();
        ISynset item = (ISynset)this.getCache().retrieveItem(id);
        if (item == null && (item = this.backing.getSynset(id)) != null) {
            this.cacheSynset(item);
        }
        return item;
    }

    protected void cacheSynset(ISynset synset) {
        ICachingDictionary.IItemCache cache = this.getCache();
        cache.cacheItem(synset);
        for (IWord word : synset.getWords()) {
            cache.cacheItem(word);
            cache.cacheWordByKey(word);
        }
    }

    @Override
    public Iterator<ISynset> getSynsetIterator(POS pos) {
        return this.backing.getSynsetIterator(pos);
    }

    @Override
    public ISenseEntry getSenseEntry(ISenseKey key) {
        this.checkOpen();
        ISenseEntry entry = this.getCache().retrieveSenseEntry(key);
        if (entry == null && (entry = this.backing.getSenseEntry(key)) != null) {
            this.getCache().cacheSenseEntry(entry);
        }
        return entry;
    }

    @Override
    public Iterator<ISenseEntry> getSenseEntryIterator() {
        return this.backing.getSenseEntryIterator();
    }

    @Override
    public IExceptionEntry getExceptionEntry(String surfaceForm, POS pos) {
        this.checkOpen();
        ExceptionEntryID id = new ExceptionEntryID(surfaceForm, pos);
        IExceptionEntry item = (IExceptionEntry)this.getCache().retrieveItem(id);
        if (item == null && (item = this.backing.getExceptionEntry(id)) != null) {
            this.getCache().cacheItem(item);
        }
        return item;
    }

    @Override
    public IExceptionEntry getExceptionEntry(IExceptionEntryID id) {
        this.checkOpen();
        IExceptionEntry item = (IExceptionEntry)this.getCache().retrieveItem(id);
        if (item == null && (item = this.backing.getExceptionEntry(id)) != null) {
            this.getCache().cacheItem(item);
        }
        return item;
    }

    @Override
    public Iterator<IExceptionEntry> getExceptionEntryIterator(POS pos) {
        return this.backing.getExceptionEntryIterator(pos);
    }

    public static class ItemCache
    implements ICachingDictionary.IItemCache {
        public static final int DEFAULT_INITIAL_CAPACITY = 16;
        public static final int DEFAULT_MAXIMUM_CAPACITY = 512;
        public static final float DEFAULT_LOAD_FACTOR = 0.75f;
        protected Lock lifecycleLock = new ReentrantLock();
        private boolean isEnabled = true;
        private int initialCapacity;
        private int maximumCapacity;
        protected Map<IItemID<?>, IItem<?>> itemCache;
        protected Map<ISenseKey, IWord> keyCache;
        protected Map<ISenseKey, ISenseEntry> senseCache;

        public ItemCache() {
            this(16, 512, true);
        }

        public ItemCache(int initialCapacity, int maxCapacity, boolean enabled) {
            this.setInitialCapacity(initialCapacity);
            this.setMaximumCapacity(maxCapacity);
            this.setEnabled(enabled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean open() throws IOException {
            if (this.isOpen()) {
                return true;
            }
            try {
                this.lifecycleLock.lock();
                int capacity = this.initialCapacity < 1 ? 16 : this.initialCapacity;
                this.itemCache = this.makeCache(capacity);
                this.keyCache = this.makeCache(capacity);
                this.senseCache = this.makeCache(capacity);
            }
            finally {
                this.lifecycleLock.unlock();
            }
            return true;
        }

        protected <K, V> Map<K, V> makeCache(int initialCapacity) {
            return new LinkedHashMap(initialCapacity, 0.75f, true);
        }

        @Override
        public boolean isOpen() {
            return this.senseCache != null;
        }

        protected void checkOpen() {
            if (!this.isOpen()) {
                throw new IHasLifecycle.ObjectClosedException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (!this.isOpen()) {
                return;
            }
            try {
                this.lifecycleLock.lock();
                this.itemCache = null;
                this.keyCache = null;
                this.senseCache = null;
            }
            finally {
                this.lifecycleLock.unlock();
            }
        }

        @Override
        public void clear() {
            if (this.itemCache != null) {
                this.itemCache.clear();
            }
            if (this.keyCache != null) {
                this.keyCache.clear();
            }
            if (this.senseCache != null) {
                this.senseCache.clear();
            }
        }

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public int getInitialCapacity() {
            return this.initialCapacity;
        }

        public void setInitialCapacity(int capacity) {
            this.initialCapacity = capacity < 1 ? 16 : capacity;
        }

        @Override
        public int getMaximumCapacity() {
            return this.maximumCapacity;
        }

        @Override
        public void setMaximumCapacity(int capacity) {
            int oldCapacity = this.maximumCapacity;
            this.maximumCapacity = capacity;
            if (this.maximumCapacity < 1 || oldCapacity <= this.maximumCapacity) {
                return;
            }
            this.reduceCacheSize(this.itemCache);
            this.reduceCacheSize(this.keyCache);
            this.reduceCacheSize(this.senseCache);
        }

        @Override
        public int size() {
            this.checkOpen();
            return this.itemCache.size() + this.keyCache.size() + this.senseCache.size();
        }

        @Override
        public void cacheItem(IItem<?> item) {
            this.checkOpen();
            if (!this.isEnabled()) {
                return;
            }
            this.itemCache.put((IItemID<?>)item.getID(), item);
            this.reduceCacheSize(this.itemCache);
        }

        @Override
        public void cacheWordByKey(IWord word) {
            this.checkOpen();
            if (!this.isEnabled()) {
                return;
            }
            this.keyCache.put(word.getSenseKey(), word);
            this.reduceCacheSize(this.keyCache);
        }

        @Override
        public void cacheSenseEntry(ISenseEntry entry) {
            this.checkOpen();
            if (!this.isEnabled()) {
                return;
            }
            this.senseCache.put(entry.getSenseKey(), entry);
            this.reduceCacheSize(this.senseCache);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reduceCacheSize(Map<?, ?> cache) {
            if (!this.isOpen() || this.maximumCapacity < 1 || cache.size() < this.maximumCapacity) {
                return;
            }
            Map<?, ?> map = cache;
            synchronized (map) {
                int remove = cache.size() - this.maximumCapacity;
                Iterator<?> itr = cache.keySet().iterator();
                for (int i = 0; i <= remove; ++i) {
                    if (!itr.hasNext()) continue;
                    itr.next();
                    itr.remove();
                }
            }
        }

        @Override
        public <T extends IItem<D>, D extends IItemID<T>> T retrieveItem(D id) {
            this.checkOpen();
            return (T)this.itemCache.get(id);
        }

        @Override
        public IWord retrieveWord(ISenseKey key) {
            this.checkOpen();
            return this.keyCache.get(key);
        }

        @Override
        public ISenseEntry retrieveSenseEntry(ISenseKey key) {
            this.checkOpen();
            return this.senseCache.get(key);
        }
    }
}

