/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.event;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.render.RenderKit;
import org.icefaces.impl.application.LazyPushManager;
import org.icefaces.impl.application.WindowScopeManager;
import org.icefaces.impl.event.UIOutputWriter;
import org.icefaces.impl.push.SessionViewManager;
import org.icefaces.impl.renderkit.DOMRenderKit;
import org.icefaces.render.ExternalScript;
import org.icefaces.util.EnvUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeSetup
implements SystemEventListener {
    public static final String ViewState = BridgeSetup.class.getName() + "::ViewState";
    private static final Logger log = Logger.getLogger(BridgeSetup.class.getName());
    private int seed = 0;
    private boolean standardFormSerialization;
    private boolean deltaSubmit;
    private boolean disableDefaultErrorPopups;

    public BridgeSetup() {
        FacesContext fc = FacesContext.getCurrentInstance();
        this.deltaSubmit = EnvUtils.isDeltaSubmit(fc);
        this.standardFormSerialization = EnvUtils.isStandardFormSerialization(fc);
        this.disableDefaultErrorPopups = EnvUtils.disableDefaultErrorPopups(fc);
    }

    public boolean isListenerForSource(Object source) {
        return true;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!EnvUtils.isICEfacesView(context)) {
            return;
        }
        if (!EnvUtils.hasHeadAndBodyComponents(context)) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "ICEfaces configured for view " + context.getViewRoot().getViewId() + " but h:head and h:body components are required");
            }
            return;
        }
        UIViewRoot root = context.getViewRoot();
        final ExternalContext externalContext = context.getExternalContext();
        root.addComponentResource(context, (UIComponent)new JavascriptResourceOutput("jsf.js", "javax.faces"), "head");
        String invalidateHTTPCache = "";
        if (EnvUtils.isUniqueResourceURLs(context)) {
            invalidateHTTPCache = "?rand=" + this.hashCode();
        }
        if (EnvUtils.isICEpushPresent()) {
            root.addComponentResource(context, (UIComponent)new JavascriptResourceOutput("icepush.js" + invalidateHTTPCache), "head");
        }
        root.addComponentResource(context, (UIComponent)new JavascriptResourceOutput("bridge.js" + invalidateHTTPCache), "head");
        RenderKit rk = context.getRenderKit();
        if (rk instanceof DOMRenderKit) {
            DOMRenderKit drk = (DOMRenderKit)rk;
            List<ExternalScript> scriptRenderers = drk.getCustomRenderScripts();
            String value = "";
            int i = 0;
            for (ExternalScript es : scriptRenderers) {
                ++i;
                String contextParamName = es.contextParam();
                boolean insertHere = true;
                if (!contextParamName.equals("Null")) {
                    value = externalContext.getInitParameter(contextParamName);
                    boolean bl = insertHere = value != null && !value.equalsIgnoreCase("");
                }
                if (!insertHere) continue;
                GenericScriptWriter externalScript = new GenericScriptWriter(es.scriptURL() + value);
                externalScript.setTransient(true);
                String externalScriptId = "external-script-" + i;
                externalScript.setId(externalScriptId);
                externalScript.getAttributes().put("name", externalScriptId);
                root.addComponentResource(context, (UIComponent)externalScript, "head");
            }
            HashSet<ResourceDependency> addedResDeps = new HashSet<ResourceDependency>();
            List<String> mandatoryResourceComponents = drk.getMandatoryResourceComponents();
            for (String compClassName : mandatoryResourceComponents) {
                try {
                    ResourceDependency resDep;
                    Class<?> compClass = Class.forName(compClassName);
                    ResourceDependencies resDeps = compClass.getAnnotation(ResourceDependencies.class);
                    if (resDeps != null) {
                        for (ResourceDependency resDep2 : resDeps.value()) {
                            BridgeSetup.addMandatoryResourceDependency(context, root, compClassName, addedResDeps, resDep2);
                        }
                    }
                    if ((resDep = compClass.getAnnotation(ResourceDependency.class)) == null) continue;
                    BridgeSetup.addMandatoryResourceDependency(context, root, compClassName, addedResDeps, resDep);
                }
                catch (Exception e) {
                    if (!log.isLoggable(Level.WARNING)) continue;
                    log.log(Level.WARNING, "When processing mandatory resource components, could not create instance of '" + compClassName + "'");
                }
            }
        }
        try {
            String tempWindowID = "unknownWindow";
            WindowScopeManager.ScopeMap windowScope = WindowScopeManager.lookupWindowScope(context);
            if (null != windowScope) {
                tempWindowID = windowScope.getId();
            } else {
                log.log(Level.WARNING, "Unable to find WindowScope for view " + context.getViewRoot().getViewId());
            }
            final String windowID = tempWindowID;
            final String viewID = this.assignViewID(externalContext);
            Map viewScope = root.getViewMap();
            final boolean sendDisposeWindow = !EnvUtils.isLazyWindowScope(context) || windowScope != null && BridgeSetup.containsBeans(windowScope) || viewScope != null && BridgeSetup.containsBeans(viewScope);
            UIOutputWriter icefacesSetup = new UIOutputWriter(){

                public void encode(ResponseWriter writer, FacesContext context) throws IOException {
                    String clientID = this.getClientId(context);
                    writer.startElement("span", (UIComponent)this);
                    writer.writeAttribute("id", (Object)clientID, null);
                    writer.startElement("script", (UIComponent)this);
                    writer.write("ice.setupBridge('");
                    writer.write(clientID);
                    writer.write("', '");
                    writer.write(viewID);
                    writer.write("', '");
                    writer.write(windowID);
                    writer.write("', {");
                    writer.write("deltaSubmit: ");
                    writer.write(Boolean.toString(BridgeSetup.this.deltaSubmit));
                    writer.write(",");
                    writer.write("disableDefaultErrorPopups: ");
                    writer.write(Boolean.toString(BridgeSetup.this.disableDefaultErrorPopups));
                    writer.write(",");
                    writer.write("standardFormSerialization: ");
                    writer.write(Boolean.toString(BridgeSetup.this.standardFormSerialization));
                    writer.write(",");
                    writer.write("sendDisposeWindow: ");
                    writer.write(Boolean.toString(sendDisposeWindow));
                    writer.write(",");
                    writer.write("blockUIOnSubmit: ");
                    writer.write(Boolean.toString(EnvUtils.isBlockUIOnSubmit(context)));
                    writer.write("});");
                    writer.endElement("script");
                    writer.endElement("span");
                }
            };
            icefacesSetup.setTransient(true);
            icefacesSetup.setId(viewID + "_icefaces_config");
            root.addComponentResource(context, (UIComponent)icefacesSetup, "body");
            UIForm retrieveUpdateSetup = new UIForm(){

                public String getClientId(FacesContext context) {
                    return this.getId();
                }
            };
            retrieveUpdateSetup.setTransient(true);
            retrieveUpdateSetup.setId(viewID);
            root.addComponentResource(context, (UIComponent)retrieveUpdateSetup, "body");
            if (EnvUtils.isICEpushPresent()) {
                UIOutputWriter icepushSetup = new UIOutputWriter(){

                    public void encode(ResponseWriter writer, FacesContext context) throws IOException {
                        SessionViewManager.addView(context, viewID);
                        writer.startElement("span", (UIComponent)this);
                        writer.writeAttribute("id", (Object)this.getClientId(context), null);
                        writer.startElement("script", (UIComponent)this);
                        writer.writeAttribute("type", (Object)"text/javascript", null);
                        writer.write(LazyPushManager.enablePush(context, viewID) ? "ice.setupPush('" + viewID + "');" : "");
                        Resource icepushListenResource = context.getApplication().getResourceHandler().createResource("listen.icepush");
                        String path = BridgeSetup.stripHostInfo(icepushListenResource.getRequestPath());
                        boolean isPortalEnvironment = EnvUtils.instanceofPortletRequest(externalContext.getRequest());
                        String contextPath = isPortalEnvironment ? "/" : externalContext.getRequestContextPath();
                        writer.write("ice.push.configuration.contextPath=\"" + contextPath + "\";");
                        String uriPattern = path.replace("listen.icepush", "{{command}}");
                        writer.write("ice.push.configuration.uriPattern=\"" + uriPattern + "\";");
                        writer.endElement("script");
                        writer.endElement("span");
                    }
                };
                icepushSetup.setTransient(true);
                icepushSetup.setId(viewID + "_icepush");
                root.addComponentResource(context, (UIComponent)icepushSetup, "body");
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to generate JS bridge setup.", e);
        }
    }

    private static boolean containsBeans(Map<String, Object> scopeMap) {
        for (String value : scopeMap.keySet()) {
            if (value.startsWith("org.icefaces")) continue;
            return true;
        }
        return false;
    }

    private static String stripHostInfo(String uriString) {
        try {
            URI uri = URI.create(uriString);
            return new URI(null, null, uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            return uriString;
        }
    }

    private String assignViewID(ExternalContext externalContext) {
        String viewIDParameter = (String)externalContext.getRequestParameterMap().get("ice.view");
        String viewID = viewIDParameter == null ? this.generateViewID() : viewIDParameter;
        externalContext.getRequestMap().put(ViewState, viewID);
        return viewID;
    }

    private String generateViewID() {
        return "v" + Integer.toString(this.hashCode(), 36) + Integer.toString(++this.seed, 36);
    }

    public static String getViewID(ExternalContext externalContext) {
        Map requestMap = externalContext.getRequestMap();
        return (String)requestMap.get(ViewState);
    }

    private static void addMandatoryResourceDependency(FacesContext facesContext, UIViewRoot root, String compClassName, Set<ResourceDependency> addedResDeps, ResourceDependency resDep) {
        if (addedResDeps.contains(resDep)) {
            return;
        }
        addedResDeps.add(resDep);
        BridgeSetup.addMandatoryResource(facesContext, root, compClassName, resDep.name(), resDep.library(), resDep.target());
    }

    private static void addMandatoryResource(FacesContext facesContext, UIViewRoot root, String compClassName, String name, String library, String target) {
        String rendererType;
        if (target == null || target.length() == 0) {
            target = "head";
        }
        if ((rendererType = FacesContext.getCurrentInstance().getApplication().getResourceHandler().getRendererTypeForResourceName(name)) == null || rendererType.length() == 0) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "Could not determine renderer type for mandatory resource, for component: " + compClassName + ". Resource name: " + name + ", library: " + library);
            }
        } else {
            root.addComponentResource(facesContext, (UIComponent)new ResourceOutput(rendererType, name, library), target);
        }
    }

    class GenericScriptWriter
    extends UIOutputWriter {
        private String script;

        public GenericScriptWriter(String script) {
            this.script = script;
            this.setTransient(true);
        }

        public void encode(ResponseWriter writer, FacesContext context) throws IOException {
            String clientID = this.getClientId(context);
            writer.startElement("script", (UIComponent)this);
            writer.writeAttribute("id", (Object)clientID, null);
            writer.writeAttribute("src", (Object)this.script, null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.endElement("script");
        }

        public String getRendererType() {
            return "javax.faces.resource.Script";
        }
    }

    public static class JavascriptResourceOutput
    extends UIOutput {
        public JavascriptResourceOutput(String path, String library) {
            this(path);
            this.getAttributes().put("library", library);
        }

        public JavascriptResourceOutput(String path) {
            this.setRendererType("javax.faces.resource.Script");
            this.getAttributes().put("name", path);
            this.setTransient(true);
        }
    }

    public static class ResourceOutput
    extends UIOutput {
        public ResourceOutput(String rendererType, String name, String library) {
            this.setRendererType(rendererType);
            if (name != null && name.length() > 0) {
                this.getAttributes().put("name", name);
            }
            if (library != null && library.length() > 0) {
                this.getAttributes().put("library", library);
            }
            this.setTransient(true);
        }

        public String toString() {
            return String.valueOf(this.getAttributes().get("library")) + "/" + String.valueOf(this.getAttributes().get("name"));
        }
    }
}

