/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.push.servlet;

import java.io.IOException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.FactoryFinder;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.icefaces.impl.push.servlet.ICEpushListenResource;
import org.icefaces.impl.push.servlet.ProxyHttpServletRequest;
import org.icefaces.impl.push.servlet.ProxyHttpServletResponse;
import org.icepush.PushContext;
import org.icepush.servlet.MainServlet;

public class ICEpushResourceHandler
extends ResourceHandlerWrapper
implements PhaseListener {
    private static final Logger log = Logger.getLogger(ICEpushResourceHandler.class.getName());
    private static final ReentrantLock lock = new ReentrantLock();
    private static final Condition condition = lock.newCondition();
    private AbstractICEpushResourceHandler resourceHandler;

    public ICEpushResourceHandler(final ResourceHandler resourceHandler) {
        try {
            final ServletContext servletContext = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
            String serverInfo = servletContext.getServerInfo();
            if (!serverInfo.startsWith("JBossWeb") && !serverInfo.startsWith("JBoss Web")) {
                this.resourceHandler = new ICEpushResourceHandlerImpl();
                this.resourceHandler.initialize(resourceHandler, servletContext, this);
            } else {
                final ICEpushResourceHandlerImpl impl = new ICEpushResourceHandlerImpl();
                this.resourceHandler = new BlockingICEpushResourceHandlerWrapper(impl);
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        ICEpushResourceHandler.this.resourceHandler.initialize(resourceHandler, servletContext, ICEpushResourceHandler.this);
                        ICEpushResourceHandler.this.resourceHandler = impl;
                        lock.lock();
                        try {
                            condition.signalAll();
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }).start();
            }
        }
        catch (Throwable throwable) {
            log.log(Level.INFO, "Ajax Push Resource Handling not available: " + throwable);
        }
    }

    public void afterPhase(PhaseEvent event) {
        this.resourceHandler.afterPhase(event);
    }

    public void beforePhase(PhaseEvent event) {
        this.resourceHandler.beforePhase(event);
    }

    public Resource createResource(String resourceName) {
        return this.resourceHandler.createResource(resourceName);
    }

    public PhaseId getPhaseId() {
        return this.resourceHandler.getPhaseId();
    }

    public ResourceHandler getWrapped() {
        return this.resourceHandler.getWrapped();
    }

    public void handleResourceRequest(FacesContext facesContext) throws IOException {
        this.resourceHandler.handleResourceRequest(facesContext);
    }

    public boolean isResourceRequest(FacesContext facesContext) {
        return this.resourceHandler.isResourceRequest(facesContext);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.resourceHandler.service(request, response);
    }

    public static void notifyContextShutdown(ServletContext context) {
        try {
            ((ICEpushResourceHandler)((Object)context.getAttribute(ICEpushResourceHandler.class.getName()))).shutdownMainServlet();
        }
        catch (Throwable t) {
            log.log(Level.INFO, "MainServlet not found in application scope: " + t);
        }
    }

    private void shutdownMainServlet() {
        this.resourceHandler.shutdownMainServlet();
    }

    private static class BlockingICEpushResourceHandlerWrapper
    extends AbstractICEpushResourceHandler {
        private final ICEpushResourceHandlerImpl resourceHandler;

        private BlockingICEpushResourceHandlerWrapper(ICEpushResourceHandlerImpl resourceHandler) {
            this.resourceHandler = resourceHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterPhase(PhaseEvent event) {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                this.resourceHandler.afterPhase(event);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforePhase(PhaseEvent event) {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                this.resourceHandler.beforePhase(event);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Resource createResource(String resourceName) {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                Resource resource = this.resourceHandler.createResource(resourceName);
                return resource;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Resource createResource(String resourceName, String libraryName) {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                Resource resource = this.resourceHandler.createResource(resourceName, libraryName);
                return resource;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Resource createResource(String resourceName, String libraryName, String contentType) {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                Resource resource = this.resourceHandler.createResource(resourceName, libraryName, contentType);
                return resource;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PhaseId getPhaseId() {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                PhaseId phaseId = this.resourceHandler.getPhaseId();
                return phaseId;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getRendererTypeForResourceName(String resourceName) {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                String string = this.resourceHandler.getRendererTypeForResourceName(resourceName);
                return string;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResourceHandler getWrapped() {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                ResourceHandler resourceHandler = this.resourceHandler.getWrapped();
                return resourceHandler;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleResourceRequest(FacesContext facesContext) throws IOException {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                this.resourceHandler.handleResourceRequest(facesContext);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isResourceRequest(FacesContext facesContext) {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                boolean bl = this.resourceHandler.isResourceRequest(facesContext);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean libraryExists(String libraryName) {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                boolean bl = this.resourceHandler.libraryExists(libraryName);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                this.resourceHandler.service(request, response);
            }
            finally {
                lock.unlock();
            }
        }

        void initialize(ResourceHandler resourceHandler, ServletContext servletContext, ICEpushResourceHandler icePushResourceHandler) {
            this.resourceHandler.initialize(resourceHandler, servletContext, icePushResourceHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdownMainServlet() {
            lock.lock();
            try {
                if (this.resourceHandler.mainServlet == null) {
                    condition.awaitUninterruptibly();
                }
                this.resourceHandler.shutdownMainServlet();
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static class ICEpushResourceHandlerImpl
    extends AbstractICEpushResourceHandler {
        private static final Pattern ICEpushRequestPattern = Pattern.compile(".*listen\\.icepush");
        private static final String RESOURCE_KEY = "javax.faces.resource";
        private static final String BROWSERID_COOKIE = "ice.push.browser";
        private ResourceHandler resourceHandler;
        private MainServlet mainServlet;

        private ICEpushResourceHandlerImpl() {
        }

        public void afterPhase(PhaseEvent event) {
        }

        public void beforePhase(PhaseEvent event) {
            HttpServletResponse response;
            HttpServletRequest request;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            Object BrowserID = externalContext.getRequestCookieMap().get(BROWSERID_COOKIE);
            if (!(externalContext.getRequest() instanceof HttpServletRequest)) {
                request = new ProxyHttpServletRequest(facesContext);
                response = new ProxyHttpServletResponse(facesContext);
            } else {
                request = (HttpServletRequest)externalContext.getRequest();
                response = (HttpServletResponse)externalContext.getResponse();
            }
            if (null == BrowserID) {
                ((PushContext)externalContext.getApplicationMap().get(PushContext.class.getName())).createPushId(request, response);
            }
        }

        public Resource createResource(String resourceName) {
            if ("listen.icepush".equals(resourceName)) {
                return new ICEpushListenResource((ResourceHandler)this);
            }
            return super.createResource(resourceName);
        }

        public PhaseId getPhaseId() {
            return PhaseId.RESTORE_VIEW;
        }

        public ResourceHandler getWrapped() {
            return this.resourceHandler;
        }

        public void handleResourceRequest(FacesContext facesContext) throws IOException {
            if (null == this.mainServlet) {
                this.resourceHandler.handleResourceRequest(facesContext);
                return;
            }
            ExternalContext externalContext = facesContext.getExternalContext();
            String resourceName = (String)facesContext.getExternalContext().getRequestParameterMap().get(RESOURCE_KEY);
            if ("listen.icepush".equals(resourceName)) {
                try {
                    this.mainServlet.service((HttpServletRequest)new ProxyHttpServletRequest(facesContext), (HttpServletResponse)new ProxyHttpServletResponse(facesContext));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return;
            }
            if (!(externalContext.getRequest() instanceof HttpServletRequest)) {
                this.resourceHandler.handleResourceRequest(facesContext);
                return;
            }
            HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
            HttpServletResponse response = (HttpServletResponse)externalContext.getResponse();
            String requestURI = request.getRequestURI();
            if (ICEpushRequestPattern.matcher(requestURI).find()) {
                try {
                    this.mainServlet.service(request, response);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.resourceHandler.handleResourceRequest(facesContext);
            }
        }

        public boolean isResourceRequest(FacesContext facesContext) {
            String resourceName = (String)facesContext.getExternalContext().getRequestParameterMap().get(RESOURCE_KEY);
            if ("listen.icepush".equals(resourceName)) {
                return true;
            }
            ExternalContext externalContext = facesContext.getExternalContext();
            if (!(externalContext.getRequest() instanceof HttpServletRequest)) {
                return this.resourceHandler.isResourceRequest(facesContext);
            }
            HttpServletRequest servletRequest = (HttpServletRequest)externalContext.getRequest();
            String requestURI = servletRequest.getRequestURI();
            return this.resourceHandler.isResourceRequest(facesContext) || ICEpushRequestPattern.matcher(requestURI).find();
        }

        void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            try {
                this.mainServlet.service(request, response);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }

        void initialize(ResourceHandler resourceHandler, ServletContext servletContext, ICEpushResourceHandler icePushResourceHandler) {
            this.resourceHandler = resourceHandler;
            this.mainServlet = new MainServlet(servletContext);
            servletContext.setAttribute(ICEpushResourceHandler.class.getName(), (Object)icePushResourceHandler);
            ((LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory")).getLifecycle("DEFAULT").addPhaseListener((PhaseListener)icePushResourceHandler);
        }

        void shutdownMainServlet() {
            this.mainServlet.shutdown();
        }
    }

    private static abstract class AbstractICEpushResourceHandler
    extends ResourceHandlerWrapper
    implements PhaseListener {
        private AbstractICEpushResourceHandler() {
        }

        abstract void initialize(ResourceHandler var1, ServletContext var2, ICEpushResourceHandler var3);

        abstract void service(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;

        abstract void shutdownMainServlet();
    }
}

