/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.term;

import javax.annotation.concurrent.Immutable;

@Immutable
public final class RareWordTerm {
    private final String _text;
    private final Long _cuiCode;
    private final String _rareWord;
    private final int _rareWordIndex;
    private final int _tokenCount;
    private final int _hashCode;

    public RareWordTerm(String text, Long cuiCode, String rareWord, int rareWordIndex, int tokenCount) {
        this._text = text;
        this._cuiCode = cuiCode;
        this._rareWord = rareWord;
        this._rareWordIndex = rareWordIndex;
        this._tokenCount = tokenCount;
        this._hashCode = (this._cuiCode + this._text).hashCode();
    }

    public String getText() {
        return this._text;
    }

    public Long getCuiCode() {
        return this._cuiCode;
    }

    public String getRareWord() {
        return this._rareWord;
    }

    public int getRareWordIndex() {
        return this._rareWordIndex;
    }

    public int getTokenCount() {
        return this._tokenCount;
    }

    public String[] getTokens() {
        String[] tokens = new String[this._tokenCount];
        int previousSpaceIndex = -1;
        int spaceIndex = this._text.indexOf(32);
        for (int tokenIndex = 0; spaceIndex > 0 && tokenIndex < this._tokenCount; ++tokenIndex) {
            tokens[tokenIndex] = this._text.substring(previousSpaceIndex + 1, spaceIndex);
            previousSpaceIndex = spaceIndex;
            spaceIndex = this._text.indexOf(32, previousSpaceIndex + 1);
        }
        if (previousSpaceIndex + 1 < this._text.length()) {
            tokens[this._tokenCount - 1] = this._text.substring(previousSpaceIndex + 1);
        }
        return tokens;
    }

    public boolean equals(Object value) {
        if (!(value instanceof RareWordTerm)) {
            return false;
        }
        RareWordTerm other = (RareWordTerm)value;
        return other.getCuiCode().equals(this._cuiCode) && other.getText().equals(this._text);
    }

    public int hashCode() {
        return this._hashCode;
    }
}

