/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.TreeMap;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.util.CleartkInitializationException;

public class ReflectionUtil {
    public static <T> T uncheckedCast(Object o) {
        return (T)o;
    }

    public static <T> Type getTypeArgument(Class<T> genericType, String typeParameterName, T obj) {
        Map<String, Type> typeArguments = ReflectionUtil.getTypeArguments(genericType, obj);
        return typeArguments == null ? null : typeArguments.get(typeParameterName);
    }

    public static Map<String, Type> getTypeArguments(Class<?> genericType, Object obj) {
        if (obj instanceof TypeArgumentDelegator) {
            return ((TypeArgumentDelegator)obj).getTypeArguments(genericType);
        }
        TreeMap<String, Type> typeMap = new TreeMap<String, Type>();
        return ReflectionUtil.getTypeArguments(genericType, obj.getClass(), typeMap);
    }

    public static boolean isAssignableFrom(Type type1, Type type2) {
        if (type1 instanceof Class && type2 instanceof Class) {
            return ((Class)type1).isAssignableFrom((Class)type2);
        }
        return type1.equals(type2);
    }

    private static Map<String, Type> getTypeArguments(Class<?> genericType, Type type, Map<String, Type> typeMap) {
        if (type instanceof ParameterizedType) {
            return ReflectionUtil.getTypeArguments(genericType, (ParameterizedType)type, typeMap);
        }
        if (type instanceof Class) {
            return ReflectionUtil.getTypeArguments(genericType, (Class)type, typeMap);
        }
        throw new IllegalArgumentException("type must be a ParameterizedType or Class");
    }

    private static Map<String, Type> getTypeArguments(Class<?> genericType, Class<?> classType, Map<String, Type> typeMap) {
        Type superType;
        if (genericType.isInterface()) {
            for (Type interfaceType : classType.getGenericInterfaces()) {
                Map<String, Type> result = ReflectionUtil.getTypeArguments(genericType, interfaceType, typeMap);
                if (result == null) continue;
                return result;
            }
        }
        if ((superType = classType.getGenericSuperclass()) != null) {
            return ReflectionUtil.getTypeArguments(genericType, superType, typeMap);
        }
        return null;
    }

    private static Map<String, Type> getTypeArguments(Class<?> genericType, ParameterizedType paramType, Map<String, Type> typeMap) {
        Class rawType = (Class)paramType.getRawType();
        if (rawType == genericType) {
            TypeVariable<Class<T>>[] typeVars = rawType.getTypeParameters();
            Type[] actualTypes = paramType.getActualTypeArguments();
            TreeMap<String, Type> result = new TreeMap<String, Type>();
            for (int i = 0; i < actualTypes.length; ++i) {
                while (actualTypes[i] != null && actualTypes[i] instanceof TypeVariable) {
                    String key = ReflectionUtil.typevarString((TypeVariable)actualTypes[i]);
                    if (typeMap.containsKey(key)) {
                        actualTypes[i] = typeMap.get(key);
                        continue;
                    }
                    actualTypes[i] = null;
                }
                result.put(typeVars[i].getName(), actualTypes[i]);
            }
            return result;
        }
        TypeVariable<Class<T>>[] typeVars = rawType.getTypeParameters();
        Type[] actualTypes = paramType.getActualTypeArguments();
        for (int i = 0; i < typeVars.length; ++i) {
            typeMap.put(ReflectionUtil.typevarString(typeVars[i]), actualTypes[i]);
        }
        return ReflectionUtil.getTypeArguments(genericType, paramType.getRawType(), typeMap);
    }

    private static String typevarString(TypeVariable<?> tv) {
        return tv.getGenericDeclaration().toString() + " " + tv.getName();
    }

    public static <T, U> void checkTypeParameterIsAssignable(Class<T> paramDefiningClass1, String paramName1, T object1, Class<U> paramDefiningClass2, String paramName2, U object2) throws ResourceInitializationException {
        Type type1 = ReflectionUtil.getTypeArgument(paramDefiningClass1, paramName1, object1);
        Type type2 = ReflectionUtil.getTypeArgument(paramDefiningClass2, paramName2, object2);
        if (type1 == null && type2 == null) {
            return;
        }
        if (type1 == null || type2 == null || !ReflectionUtil.isAssignableFrom(type1, type2)) {
            throw CleartkInitializationException.incompatibleTypeParameters(object1, paramName1, type1, object2, paramName2, type2);
        }
    }

    public static <T, U, E extends Exception> void checkTypeParametersAreEqual(Class<T> paramDefiningClass1, String paramName1, T object1, Class<U> paramDefiningClass2, String paramName2, U object2, Class<E> exceptionClass) throws E {
        Type type1 = ReflectionUtil.getTypeArgument(paramDefiningClass1, paramName1, object1);
        Type type2 = ReflectionUtil.getTypeArgument(paramDefiningClass2, paramName2, object2);
        if (type1 == null && type2 == null) {
            return;
        }
        if (type1 == null || type2 == null || !type1.equals(type2)) {
            try {
                throw (Exception)exceptionClass.getConstructor(String.class).newInstance(String.format("%s with %s %s is not equal to %s with %s %s", object1.getClass().getSimpleName(), paramName1, type1, object2.getClass().getSimpleName(), paramName2, type2));
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface TypeArgumentDelegator {
        public Map<String, Type> getTypeArguments(Class<?> var1);
    }
}

