/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.uima;

import java.io.IOException;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.ytex.uima.ApplicationContextHolder;
import org.apache.ctakes.ytex.uima.types.DocKey;
import org.apache.ctakes.ytex.uima.types.KeyValuePair;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@PipeBitInfo(name="Database Reader", description="Read documents from a database.", role=PipeBitInfo.Role.READER)
public class DBCollectionReader
extends CollectionReader_ImplBase {
    private static final Log log = LogFactory.getLog(DBCollectionReader.class);
    protected String queryGetDocumentKeys;
    protected String queryGetDocument;
    protected String keyTypeName = "org.apache.ctakes.ytex.uima.types.DocKey";
    protected DataSource dataSource;
    protected SimpleJdbcTemplate simpleJdbcTemplate;
    protected NamedParameterJdbcTemplate namedJdbcTemplate;
    protected TransactionTemplate txTemplate;
    protected boolean keyNameToLowerCase = true;
    List<Map<String, Object>> listDocumentIds;
    int i = 0;

    public boolean isKeyNameToLowerCase() {
        return this.keyNameToLowerCase;
    }

    public void setKeyNameToLowerCase(boolean keyNameToLowerCase) {
        this.keyNameToLowerCase = keyNameToLowerCase;
    }

    public void initialize() throws ResourceInitializationException {
        this.initializePreLoad();
        this.loadDocumentIds();
    }

    protected void initializePreLoad() throws ResourceInitializationException {
        super.initialize();
        ProcessingResourceMetaData metaData = this.getProcessingResourceMetaData();
        ConfigurationParameterSettings paramSettings = metaData.getConfigurationParameterSettings();
        this.queryGetDocumentKeys = (String)paramSettings.getParameterValue("queryGetDocumentKeys");
        this.queryGetDocument = (String)paramSettings.getParameterValue("queryGetDocument");
        this.keyTypeName = (String)paramSettings.getParameterValue("keyTypeName");
        Boolean keyNameToLowerCase = (Boolean)paramSettings.getParameterValue("keyNameToLowerCase");
        if (keyNameToLowerCase != null) {
            this.keyNameToLowerCase = keyNameToLowerCase;
        }
        String dbURL = (String)paramSettings.getParameterValue("dbURL");
        String dbDriver = (String)paramSettings.getParameterValue("dbDriver");
        this.initDB(dbDriver, dbURL);
    }

    protected void initDB(String dbDriver, String dbURL) throws ResourceInitializationException {
        if (dbURL != null && dbURL.length() > 0) {
            try {
                if (dbDriver == null || dbDriver.length() == 0) {
                    dbDriver = ApplicationContextHolder.getYtexProperties().getProperty("db.driver");
                }
                this.dataSource = new SimpleDriverDataSource((Driver)Class.forName(dbDriver).newInstance(), dbURL);
                this.txTemplate = new TransactionTemplate((PlatformTransactionManager)new DataSourceTransactionManager(this.dataSource));
            }
            catch (InstantiationException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        } else {
            this.txTemplate = (TransactionTemplate)ApplicationContextHolder.getApplicationContext().getBean("txTemplate");
            this.dataSource = (DataSource)ApplicationContextHolder.getApplicationContext().getBean("collectionReaderDataSource");
        }
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(this.dataSource);
        this.namedJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
    }

    protected void loadDocumentIds() {
        if (this.listDocumentIds == null) {
            this.listDocumentIds = (List)this.txTemplate.execute((TransactionCallback)new TransactionCallback<List<Map<String, Object>>>(){

                public List<Map<String, Object>> doInTransaction(TransactionStatus arg0) {
                    return DBCollectionReader.this.simpleJdbcTemplate.queryForList(DBCollectionReader.this.queryGetDocumentKeys, new Object[0]);
                }
            });
            this.i = 0;
        }
    }

    public void getNext(CAS aCAS) throws IOException, CollectionException {
        try {
            this.getNext(aCAS.getJCas());
        }
        catch (CASException e) {
            throw new CollectionException((Throwable)e);
        }
    }

    public void getNext(JCas aCAS) throws IOException, CollectionException {
        Map<String, Object> id;
        if (this.i < this.listDocumentIds.size()) {
            id = this.listDocumentIds.get(this.i++);
            if (log.isInfoEnabled()) {
                log.info((Object)("loading document with id = " + id));
            }
        } else {
            throw new CollectionException("no documents to process", new Object[0]);
        }
        this.getDocumentById(aCAS, id);
        this.addDocKey(aCAS, id);
    }

    private void addDocKey(JCas aCAS, Map<String, Object> id) throws CollectionException {
        DocKey docKey = new DocKey(aCAS);
        FSArray keyValuePairs = new FSArray(aCAS, id.size());
        int i = 0;
        for (Map.Entry<String, Object> idVal : id.entrySet()) {
            String key = idVal.getKey();
            Object val = idVal.getValue();
            KeyValuePair p = new KeyValuePair(aCAS);
            p.setKey(key);
            if (val instanceof Number) {
                p.setValueLong(((Number)val).longValue());
            } else if (val instanceof String) {
                p.setValueString((String)val);
            } else {
                log.warn((Object)("Don't know how to handle key attribute, converting to string, key=" + key + ", value=" + val));
                p.setValueString(val.toString());
            }
            keyValuePairs.set(i, (FeatureStructure)p);
            ++i;
        }
        docKey.setKeyValuePairs(keyValuePairs);
        docKey.addToIndexes();
    }

    protected void getDocumentById(final JCas aCAS, Map<String, Object> id) {
        Map<String, Object> idMapTmp = id;
        if (this.isKeyNameToLowerCase()) {
            idMapTmp = new HashMap<String, Object>();
            for (Map.Entry<String, Object> e : id.entrySet()) {
                idMapTmp.put(e.getKey().toLowerCase(), e.getValue());
            }
        }
        final Map<String, Object> idQuery = idMapTmp;
        this.txTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus arg0) {
                DBCollectionReader.this.namedJdbcTemplate.query(DBCollectionReader.this.queryGetDocument, idQuery, new RowCallbackHandler(){
                    boolean bFirstRowRead = false;

                    public void processRow(ResultSet rs) throws SQLException {
                        if (!this.bFirstRowRead) {
                            DefaultLobHandler lobHandler = new DefaultLobHandler();
                            String clobText = lobHandler.getClobAsString(rs, 1);
                            aCAS.setDocumentText(clobText);
                            this.bFirstRowRead = true;
                        } else {
                            log.error((Object)("Multiple documents for document key: " + idQuery));
                        }
                    }
                });
                return null;
            }
        });
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.i, this.listDocumentIds.size(), "entities")};
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.i < this.listDocumentIds.size();
    }

    public void close() throws IOException {
        this.listDocumentIds = null;
        this.i = 0;
    }
}

