/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.uima.annotators;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.refsem.OntologyConcept;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.MedicationEventMention;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Metamap Annotation xlater", description="Create MedicationEventMention/EntityMention annotations for each set of CandidateConcept annotations that span the same text.", role=PipeBitInfo.Role.SPECIAL, products={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class MetaMapToCTakesAnnotator
extends JCasAnnotator_ImplBase {
    private static final Log log = LogFactory.getLog(MetaMapToCTakesAnnotator.class);
    private boolean checkMedications = false;
    private static final String[] medicationAbrs = new String[]{"aapp", "antb", "bacs", "bodm", "carb", "chem", "chvf", "chvs", "clnd", "eico", "elii", "enzy", "hops", "horm", "imft", "inch", "irda", "lipd", "nnon", "nsba", "opco", "orch", "phsu", "rcpt", "strd", "vita"};
    private static Set<String> setMedicationAbrs = new HashSet<String>(Arrays.asList(medicationAbrs));

    private Set<NegSpan> getNegatedSpans(JCas jcas) {
        HashSet<NegSpan> negSet = new HashSet<NegSpan>();
        Type negType = jcas.getTypeSystem().getType("org.metamap.uima.ts.Negation");
        if (negType == null) {
            log.debug((Object)"no negated concepts");
        } else {
            Feature spanFeature = negType.getFeatureByBaseName("ncSpans");
            if (spanFeature == null) {
                log.warn((Object)"no ncSpans feature!");
            } else {
                for (Annotation negAnno : jcas.getAnnotationIndex(negType)) {
                    FSArray spanArr = (FSArray)negAnno.getFeatureValue(spanFeature);
                    if (spanArr == null) continue;
                    for (int i = 0; i < spanArr.size(); ++i) {
                        negSet.add(new NegSpan((Annotation)spanArr.get(i)));
                    }
                }
            }
        }
        return negSet;
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        Set<NegSpan> negSet = this.getNegatedSpans(jcas);
        Type candidateType = jcas.getTypeSystem().getType("org.metamap.uima.ts.Candidate");
        if (candidateType == null) {
            log.debug((Object)"no candidate concepts");
            return;
        }
        Feature cuiFeature = candidateType.getFeatureByBaseName("cui");
        if (cuiFeature == null) {
            log.warn((Object)"no cui feature!");
            return;
        }
        Feature tuiFeature = candidateType.getFeatureByBaseName("semanticTypes");
        if (tuiFeature == null) {
            log.warn((Object)"no semanticTypes feature!");
            return;
        }
        FSIterator candidateIter = jcas.getAnnotationIndex(candidateType).iterator();
        int begin = -1;
        int end = -1;
        HashMap<String, OntologyConcept> concepts = new HashMap<String, OntologyConcept>();
        boolean bMedication = false;
        while (candidateIter.hasNext()) {
            Annotation annoCandidate = (Annotation)candidateIter.next();
            if (begin >= 0 && begin == annoCandidate.getBegin() && end == annoCandidate.getEnd()) {
                bMedication = this.addConcept(jcas, concepts, annoCandidate, cuiFeature, tuiFeature, bMedication);
                continue;
            }
            this.addNamedEntity(jcas, begin, end, concepts, bMedication, negSet);
            begin = annoCandidate.getBegin();
            end = annoCandidate.getEnd();
            bMedication = this.addConcept(jcas, concepts, annoCandidate, cuiFeature, tuiFeature, bMedication);
        }
        this.addNamedEntity(jcas, begin, end, concepts, bMedication, negSet);
    }

    private void addNamedEntity(JCas jcas, int begin, int end, Map<String, OntologyConcept> concepts, boolean bMedication, Set<NegSpan> negSet) {
        if (concepts.isEmpty()) {
            return;
        }
        IdentifiedAnnotation neLast = bMedication ? new MedicationEventMention(jcas) : new EntityMention(jcas);
        neLast.setPolarity(negSet.contains(new NegSpan(begin, end)) ? -1 : 1);
        neLast.setBegin(begin);
        neLast.setEnd(end);
        FSArray ocArr = new FSArray(jcas, concepts.size());
        int ocArrIdx = 0;
        for (OntologyConcept oc : concepts.values()) {
            ocArr.set(ocArrIdx, (FeatureStructure)oc);
            ++ocArrIdx;
        }
        neLast.setOntologyConceptArr(ocArr);
        concepts.clear();
        neLast.addToIndexes();
    }

    private boolean addConcept(JCas jcas, Map<String, OntologyConcept> concepts, Annotation annoCandidate, Feature cuiFeature, Feature tuiFeature, boolean bMedication) {
        String cui = annoCandidate.getStringValue(cuiFeature);
        if (concepts.containsKey(cui)) {
            return bMedication;
        }
        OntologyConcept oc = new OntologyConcept(jcas);
        oc.setCode(cui);
        oc.setCodingScheme("METAMAP");
        StringArray tuiArr = (StringArray)annoCandidate.getFeatureValue(tuiFeature);
        List<String> tuis = null;
        if (tuiArr != null) {
            tuis = Arrays.asList(tuiArr.toStringArray());
        }
        concepts.put(cui, oc);
        return this.checkMedications && tuis != null ? !Collections.disjoint(setMedicationAbrs, tuis) : false;
    }

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.checkMedications = (Boolean)aContext.getConfigParameterValue("checkMedications");
    }

    public static class NegSpan {
        int begin;
        int end;

        public int getBegin() {
            return this.begin;
        }

        public void setBegin(int begin) {
            this.begin = begin;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.begin;
            result = 31 * result + this.end;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NegSpan other = (NegSpan)obj;
            if (this.begin != other.begin) {
                return false;
            }
            return this.end == other.end;
        }

        public NegSpan(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        public NegSpan(Annotation anno) {
            this.begin = anno.getBegin();
            this.end = anno.getEnd();
        }
    }
}

