/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.dictionary;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.ctakes.dictionary.lookup2.dictionary.AbstractRareWordDictionary;
import org.apache.ctakes.dictionary.lookup2.term.RareWordTerm;
import org.apache.ctakes.dictionary.lookup2.util.JdbcConnectionFactory;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;

public final class JdbcRareWordDictionary
extends AbstractRareWordDictionary {
    private static final Logger LOGGER = Logger.getLogger((String)"JdbcRareWordDictionary");
    public static final String RARE_WORD_TABLE = "rareWordTable";
    private PreparedStatement _selectTermCall;

    public JdbcRareWordDictionary(String name, UimaContext uimaContext, Properties properties) throws SQLException {
        this(name, properties.getProperty("jdbcDriver"), properties.getProperty("jdbcUrl"), properties.getProperty("jdbcUser"), properties.getProperty("jdbcPass"), properties.getProperty(RARE_WORD_TABLE));
    }

    public JdbcRareWordDictionary(String name, String jdbcDriver, String jdbcUrl, String jdbcUser, String jdbcPass, String tableName) throws SQLException {
        super(name);
        boolean connected = false;
        try {
            Connection connection = JdbcConnectionFactory.getInstance().getConnection(jdbcDriver, jdbcUrl, jdbcUser, jdbcPass);
            connected = connection != null;
            this._selectTermCall = JdbcRareWordDictionary.createSelectCall(connection, tableName);
        }
        catch (SQLException sqlE) {
            if (!connected) {
                LOGGER.error((Object)("Could not Connect to Dictionary " + name));
            } else {
                LOGGER.error((Object)"Could not create Term Data Selection Call", (Throwable)sqlE);
            }
            throw sqlE;
        }
        LOGGER.info((Object)("Connected to cui and term table " + tableName.toUpperCase()));
    }

    @Override
    public Collection<RareWordTerm> getRareWordHits(String rareWordText) {
        ArrayList<RareWordTerm> rareWordTerms = new ArrayList<RareWordTerm>();
        try {
            this.fillSelectCall(rareWordText);
            ResultSet resultSet = this._selectTermCall.executeQuery();
            while (resultSet.next()) {
                RareWordTerm rareWordTerm = new RareWordTerm(resultSet.getString(FIELD_INDEX.TEXT.__index), resultSet.getLong(FIELD_INDEX.CUI.__index), resultSet.getString(FIELD_INDEX.RWORD.__index), resultSet.getInt(FIELD_INDEX.RINDEX.__index), resultSet.getInt(FIELD_INDEX.TCOUNT.__index));
                rareWordTerms.add(rareWordTerm);
            }
            resultSet.close();
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage());
        }
        return rareWordTerms;
    }

    private static PreparedStatement createSelectCall(Connection connection, String tableName) throws SQLException {
        String lookupSql = "SELECT * FROM " + tableName + " WHERE RWORD = ?";
        return connection.prepareStatement(lookupSql);
    }

    private PreparedStatement fillSelectCall(String rareWordText) throws SQLException {
        this._selectTermCall.clearParameters();
        this._selectTermCall.setString(1, rareWordText);
        return this._selectTermCall;
    }

    private static enum FIELD_INDEX {
        CUI(1),
        RINDEX(2),
        TCOUNT(3),
        TEXT(4),
        RWORD(5);

        private final int __index;

        private FIELD_INDEX(int index) {
            this.__index = index;
        }
    }
}

