/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.util;

import javax.annotation.concurrent.Immutable;
import org.apache.ctakes.dictionary.lookup2.textspan.DefaultTextSpan;
import org.apache.ctakes.dictionary.lookup2.textspan.TextSpan;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.uima.jcas.tcas.Annotation;

@Immutable
public final class FastLookupToken {
    private final TextSpan _textSpan;
    private final String _text;
    private String _variant;

    public FastLookupToken(Annotation jcasAnnotation) {
        String canonicalForm;
        this._textSpan = new DefaultTextSpan(jcasAnnotation.getBegin(), jcasAnnotation.getEnd());
        this._text = jcasAnnotation.getCoveredText().toLowerCase();
        if (jcasAnnotation instanceof WordToken && (canonicalForm = ((WordToken)jcasAnnotation).getCanonicalForm()) != null && !canonicalForm.equals(this._text)) {
            this._variant = canonicalForm;
        }
    }

    public TextSpan getTextSpan() {
        return this._textSpan;
    }

    public int getStart() {
        return this._textSpan.getStart();
    }

    public int getEnd() {
        return this._textSpan.getEnd();
    }

    public int getLength() {
        return this._textSpan.getLength();
    }

    public String getText() {
        return this._text;
    }

    public String getVariant() {
        return this._variant;
    }

    public boolean equals(Object value) {
        return value != null && value instanceof FastLookupToken && this._textSpan.equals(((FastLookupToken)value).getTextSpan());
    }

    public int hashCode() {
        return this._textSpan.hashCode();
    }
}

