/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public final class SemanticUtil {
    private static final String[] DRUG = new String[]{"T109", "T110", "T114", "T115", "T116", "T118", "T119", "T121", "T122", "T123", "T124", "T125", "T126", "T127", "T129", "T130", "T131", "T195", "T196", "T197", "T200", "T203"};
    private static final String[] DISO = new String[]{"T019", "T020", "T037", "T047", "T048", "T049", "T050", "T190", "T191"};
    private static final String[] FIND = new String[]{"T033", "T034", "T040", "T041", "T042", "T043", "T044", "T045", "T046", "T056", "T057", "T184"};
    private static final String[] PROC = new String[]{"T059", "T060", "T061"};
    private static final String[] ANAT = new String[]{"T021", "T022", "T023", "T024", "T025", "T026", "T029", "T030"};
    private static final Collection<String> ANAT_TUIS = new HashSet<String>(Arrays.asList(ANAT));
    private static final Collection<String> DISO_TUIS = new HashSet<String>(Arrays.asList(DISO));
    private static final Collection<String> FIND_TUIS = new HashSet<String>(Arrays.asList(FIND));
    private static final Collection<String> PROC_TUIS = new HashSet<String>(Arrays.asList(PROC));
    private static final Collection<String> DRUG_TUIS = new HashSet<String>(Arrays.asList(DRUG));

    private SemanticUtil() {
    }

    public static Integer getTuiSemanticGroupId(String tui) {
        if (ANAT_TUIS.contains(tui)) {
            return 6;
        }
        if (DISO_TUIS.contains(tui)) {
            return 2;
        }
        if (FIND_TUIS.contains(tui)) {
            return 3;
        }
        if (PROC_TUIS.contains(tui)) {
            return 5;
        }
        if (DRUG_TUIS.contains(tui)) {
            return 1;
        }
        return 0;
    }
}

